<?php
$indexPath = __DIR__ . '/index.php';
$backupPath = __DIR__ . '/backup/index.php.bak';
$hashPath = __DIR__ . '/backup/index.hash';

// Jika file index.php hilang, restore langsung
if (!file_exists($indexPath)) {
    copy($backupPath, $indexPath);
    exit('index.php hilang — sudah direstore.');
}

// Cek isi file (hash md5)
$currentHash = md5(file_get_contents($indexPath));
$savedHash = trim(file_get_contents($hashPath));

// Jika file berubah, restore
if ($currentHash !== $savedHash) {
    copy($backupPath, $indexPath);
    exit('index.php diubah — sudah dikembalikan.');
}

echo 'index.php aman, tidak berubah.';
