<?php
// Nama file yang ingin dikunci (relatif terhadap folder root tinyfilemanager)
$protected_file = 'tinyfilemanager.php';

// Aksi yang tidak diizinkan
$blocked_actions = ['delete', 'edit', 'save', 'upload', 'mkdir', 'rename'];

// Ambil parameter dari request (ubah sesuai parameter yang dipakai Tiny File Manager)
$action = $_REQUEST['action'] ?? '';
$target = $_REQUEST['file'] ?? $_REQUEST['dir'] ?? ''; // Coba ambil 'file' atau 'dir' tergantung Tiny File Manager

// Normalisasi path target
$target = trim($target, '/\\');

// Cek jika aksi dilarang dan target file yang ingin dikunci
if (in_array($action, $blocked_actions)) {
    // Bisa cuma cocok nama file, atau bisa path lengkap kalau ada subfolder
    if ($target === $protected_file || basename($target) === $protected_file) {
        http_response_code(403);
        exit("403 Forbidden - File '{$protected_file}' tidak boleh diubah/hapus.");
    }
}

// Kalau lolos, lanjutkan ke Tiny File Manager asli
require __DIR__ . '/13cabvictoria.com.au/tinyfilemanager.php';
