<?php
/**
 * Preset headers data.
 */

return [
	'default' => [],
	'classic' => [
		'header_layout'          => 'smart-legacy',
		'header_width'           => 'full-wrap',
		'header_social_style'    => 'c',
		'header_search_type'     => 'form',
		
		'header_scheme_top'      => 'light',
		'header_items_top_left'  => ['ticker'],
		'header_items_top_right' => ['social-icons', 'search'],
		
		'header_scheme_mid'      => 'light',
		'header_items_mid_left'  => ['logo'],
		'header_items_mid_right' => ['text'],
		
		'header_width_bot'       => 'contain',
		'header_items_bot_left'  => ['nav-menu'],

		'header_nav_hov_style'   => 'b',

		'header_mob_scheme_mid'  => 'light'
	],

	'sports' => [
		// 'header_layout'            => 'smart-b',
		'header_width'             => 'full',
		// 'header_social_style'      => 'b',
		
		'header_items_top_left'   => ['nav-small'],
		'header_items_top_right'  => ['social-icons', 'search'],
		'css_header_height_top'   => '45',
		'css_header_bg_top'       => '#001526',

		'header_items_mid_left'    => ['hamburger', 'logo'],
		'header_items_mid_center'  => ['nav-menu'],
		'header_items_mid_right'   => ['button'],
		'css_header_height_mid'    => '86',
		'css_header_bg_sd_mid'     => '#081736',
		
		'header_search_overlay_scheme'  => '',
		
		'css_drop_bg_dark'         => '#081736',
		'css_nav_space'            => '16',
		'css_nav_typo_size'        => '15',
		'css_nav_typo_transform'   => 'uppercase',
		'css_nav_typo_weight'      => 'bold',
		'css_nav_small_first_nopad' => '1',
		'css_nav_typo_spacing'      => '0.05',
		'css_nav_color_dark'       => '#ffffff',
		'css_nav_hover_dark'       => '--c-main',
		'css_nav_arrow_color_dark' => '#aaaaaa',
		'css_nav_small_color_dark'      => '#dddddd',
		'header_offcanvas_desktop_menu' => 1,
		
		'header_mob_items_mid_right' => ['scheme-switch', 'search'],
		'css_header_mob_height_mid'  => '70',
		'css_header_mob_bg_sd_mid'   => '#081736',
		'css_header_offcanvas_bg_sd' => '#081736'

	],

	'news' => [
		'header_width'            => 'full',
		'header_items_top_left'   => ['nav-small'],
		'header_items_top_right'  => ['social-icons', 'scheme-switch', 'search'],
		'css_header_height_top'   => '45',
		'css_header_bg_sd_top'    => '#0b101b',

		'header_items_mid_left'     => ['hamburger', 'logo'],
		'header_items_mid_center'   => ['nav-menu'],
		'header_items_mid_right'    => ['button'],
		'css_header_height_mid'     => '84',
		'css_header_bg_sd_mid'      => '#081736',
		'css_header_grad_mid'       => 1,
		'css_header_grad_mid_c1'    => '#050e25',
		'css_header_grad_mid_c2'    => '#141c2b',
		'css_header_grad_mid_angle' => '-90',

		'header_search_overlay_scheme'  => '',
		'header_offcanvas_desktop_menu' => 1,

		'css_nav_space'              => '15',
		'css_nav_small_first_nopad'  => '1',
		'css_nav_typo_size'          => '16',
		'css_nav_typo_spacing'       => '0',
		'css_drop_bg_dark'           => '#0b1321',
		'header_nav_hov_style'       => 'b',
		'css_nav_hov_b_weight'       => '3',
		'css_nav_color_dark'         => '#ffffff',
		'css_nav_arrow_color_dark'   => '#969696',
		'css_hov_bg_dark'            => 'rgba(255,255,255,0.01)',
		'css_drop_hov_bg_dark'       => 'rgba(255,255,255,0.03)',
		
		'header_mob_items_mid_right' => ['scheme-switch', 'search'],
		'css_header_mob_height_mid'  => '70',
		'css_header_mob_bg_sd_mid'   => '#141c2b',
		'css_header_offcanvas_bg_sd' => '#0b1321'
	],

	'good-news' => [
		'header_layout'            => 'smart-b',
		'header_width'             => 'full-wrap',
		'header_social_style'      => 'b',
		
		'header_items_mid_left'    => ['social-icons'],
		'header_items_mid_center'  => ['logo'],
		'header_items_mid_right'   => ['button'],
		
		'header_items_bot_left'    => ['hamburger'],
		'header_items_bot_center'  => ['nav-menu'],
		'header_items_bot_right'   => ['search'],
	],

	'tech' => [
		// 'header_layout'            => 'smart-a',
		'header_width'             => 'full',
		// 'header_social_style'      => 'a',
		'css_header_c_shadow'      => 'rgba(0,0,0,0.05)',
		'header_items_top_left'    => ['nav-small'],
		'header_items_top_right'   => ['social-icons', 'scheme-switch', 'search'],
		'css_header_bg_top'        => '--c-main',
		'css_header_height_top'    => '36',
		
		'header_scheme_mid'        => 'light',
		'header_items_mid_left'    => ['hamburger'],
		'header_items_mid_center'  => ['logo'],
		'header_items_mid_right'   => ['button'],
		'css_header_height_mid'    => '85',
		
		'header_scheme_bot'         => 'light',
		// 'header_items_bot_left'     => [],
		'header_items_bot_center'   => ['nav-menu'],
		// 'header_items_bot_right'    => [],

		'css_header_border_top_bot'     => '0',
		'css_header_social_color'       => '#fff',
		'header_offcanvas_scheme'       => 'light',
		'header_search_overlay_scheme'  => '',
		'css_header_social_hov_color'   => '#f2f2f2',
		'css_header_search_hov_color'   => '#f2f2f2',
		'css_header_switcher_hov_color' => '#f2f2f2',
		'css_nav_arrow_color_light'     => '#353535',
		'css_nav_small_color_dark'      => 'rgba(255,255,255,0.92)',
		'css_nav_small_hover_dark'      => '#fff',

		'header_mob_scheme_mid'      => 'light',
		'header_mob_items_mid_right' => ['scheme-switch', 'search']
	],

	'tech-2' => [
		'header_width'             => 'full',
		
		'header_items_top_left'    => ['nav-small'],
		'header_items_top_right'   => ['social-icons'],
		'css_header_height_top'    => '34',

		'header_scheme_mid'        => 'light',
		'header_items_mid_left'    => ['logo', 'nav-menu'],
		'header_items_mid_right'   => ['scheme-switch', 'search'],
		'css_header_height_mid'    => '76',
		
		'header_scheme_bot'         => 'light',
		'css_header_c_shadow'       => 'rgba(0,0,0,0.05)',
		'css_header_border_top_bot' => '0',

		'header_offcanvas_scheme'       => 'light',
		'header_offcanvas_desktop_menu' => 1,
		'header_search_overlay_scheme'  => '',
		'css_header_social_hov_color'   => '#f2f2f2',

		'css_header_social_space'   => '5',

		'header_mob_scheme_mid'      => 'light',
		'header_mob_items_mid_right' => ['scheme-switch', 'search']
	],

	'zine' => [
		'header_sticky'             => 'bot',
		'header_items_top_left'    => ['date', 'nav-small'],
		'header_items_top_right'   => ['social-icons'],
		'css_header_height_top'    => '38',
		'css_header_c_shadow'      => 'rgba(10,10,10,0.04)',
		
		'header_items_mid_left'    => ['logo'],
		'header_items_mid_center'  => [],
		'header_items_mid_right'   => ['text'],
		'css_header_bg_sd_mid'     => '#181818',
		'css_header_height_mid'    => '140',
		
		'header_items_bot_left'        => ['hamburger', 'nav-menu'],
		'header_items_bot_center'      => [],
		'header_items_bot_right'       => ['search'],
		'css_header_height_bot'        => '52',
		'css_header_border_bottom_bot' => '0',
		'css_header_hamburger_scale'   => '0.69',
		// Would have trouble with hov-b.
		// 'css_header_border_bottom_bot' => '3',
		// 'css_header_c_border_bot_bot'  => '--c-main',

		'header_nav_hov_style'      => 'b',
		'css_nav_space'             => '16',
		'css_nav_typo_spacing'      => '0.02',
		'header_offcanvas_desktop_menu' => 1,

		'css_header_mob_border_top_mid' => '3',
	],

	'trendy' => [
		'header_items_top_left'    => ['date', 'nav-small'],
		'header_items_top_right'   => ['social-icons'],
		'css_header_height_top'    => '38',
		'css_header_c_shadow'      => 'rgba(10,10,10,0.04)',
		
		'header_scheme_mid'        => 'light',
		'header_items_mid_left'    => ['logo'],
		'header_items_mid_center'  => [],
		'header_items_mid_right'   => ['text'],
		'css_header_bg_sd_mid'     => '#181818',
		'css_header_height_mid'    => '146',
		
		'header_scheme_bot'          => 'light',
		'header_items_bot_left'      => ['hamburger', 'nav-menu'],
		'header_items_bot_center'    => [],
		'header_items_bot_right'     => ['search'],
		'css_header_height_bot'      => '52',
		'css_header_hamburger_scale' => '0.65',

		'css_nav_space'             => '16',
		'css_nav_typo_spacing'      => '0.02',

		'header_mob_scheme_mid'  => 'light'
	],

	'social-life' => [
		'header_layout'           => 'smart-b',
		'header_items_mid_left'   => ['social-icons'],
		'header_items_mid_center' => ['logo'],
		'header_items_mid_right'  => ['button'],
		'header_items_bot_left'   => ['hamburger'],
		'header_items_bot_center' => ['nav-menu'],
		'header_items_bot_right'  => ['search'],
		'header_scheme_bot'       => 'light',

		'css_header_c_shadow'            => 'rgba(10,0,0,0.06)',
		'css_header_height_bot'          => 66,
		'css_header_border_bottom_bot'   => 1,
		'css_header_bg_mid'              => '#921125',
		'css_header_bg_sd_mid'           => '#921125',
		'css_nav_typo_weight'            => 'bold',
		'css_nav_typo_size'              => 15,
		'css_nav_typo_spacing'           => '0.07',
		'css_nav_arrow_color_light'      => '#565656',

		'header_button_style'           => 'a',
		'header_social_style'           => 'b',
		'css_header_button_bg_sd'        => 'rgba(255,255,255,0.15)',
		'css_header_button_typo_size'    => 13,
		'css_header_button_typo_spacing' => '0.13',
		'css_header_social_hov_color_sd' => '#e5e5e5',
		'css_header_social_color_sd'     => 'rgba(255,255,255,0.9)',

		'header_offcanvas_desktop_menu' => 1,
		'css_header_offcanvas_menu_typo_transform' => 'uppercase',
		'css_header_offcanvas_menu_typo_spacing'   => [
			'main' => '.05',
			'medium' => '',
			'small'  => '',
			'limit'  => 0
		],

		'css_header_mob_bg_mid' => '#921125',
		'css_header_mob_border_bottom_mid' => 0,
	],

	'gaming' => [
		'header_width' => 'full',

		'header_items_mid_left'  => [],
		'header_items_mid_center' => ['logo'],
		'header_items_mid_right'  => [],
		'header_scheme_mid'      => 'light',
		'css_header_height_mid'  => '220',

		'header_items_bot_left'    => ['hamburger'],
		'header_items_bot_center'  => ['nav-menu'],
		'header_items_bot_right'   => ['social-icons', 'search'],
		'css_header_height_bot'    => '54',

		'css_header_social_hov_color_sd' => '#f2f2f2',
		'header_search_overlay_scheme'   => '',
		'header_offcanvas_desktop_menu'  => 1,

		'css_header_mob_height_mid'  => '70',
		'header_mob_scheme_mid'      => 'light',
		'header_mob_items_mid_right' => ['scheme-switch', 'search']
	],

	'informed' => [
		'header_width'  => 'full',
		'header_layout' => 'smart-b',
		'header_items_mid_left'    => ['hamburger', 'logo'],
		'header_items_mid_center'  => ['nav-menu'],
		'css_header_height_mid'    => '66',

		'header_social_style'        => 'b',
		'css_header_social_size'     => '16',
		'css_header_social_box_size' => '36',
		'css_header_search_size'     => '18',

		'css_nav_typo_weight'        => 'bold',
		'css_nav_typo_size'          => '16',
		'css_nav_typo_transform'     => 'uppercase',
		'css_nav_small_first_nopad'  => '1',
		'css_nav_typo_spacing'       => '0.03',
		'css_nav_hover_dark'         => '#dddddd',
		'css_drop_active_dark'       => '#a0a0a0',
		'css_header_social_hov_color_sd'    => '#bcbcbc',
		'css_header_search_hov_color_sd'    => '#bcbcbc',
		'css_header_hamburger_hov_color_sd' => '#bcbcbc',

		'css_header_mob_border_bottom_mid'  => 0,
		'css_header_mob_search_size'        => '19',
	],

	'geeks-empire' => [
		'header_items_mid_left'    => ['hamburger', 'button'],
		'header_items_mid_center'  => ['logo'],
		'header_items_bot_center'  => ['nav-menu'],
		
		'css_header_height_mid'        => 72,
		'css_header_bg_sd_mid'         => '#1a1b1d',
		'css_header_height_bot'        => 42,
		'css_header_bg_bot'            => '#1a1b1d',
		'css_header_border_top_bot'    => 1,
		'css_header_c_border_top_sd_bot' => '#383838',
		'css_header_border_bottom_bot'   => 0,
		'css_header_c_border_bot_sd_bot' => '#383838',

		'header_nav_hov_style'           => 'b',
		'css_hov_bg_dark'                => 'rgba(239,239,239,0)',
		'css_nav_hov_b_weight'           => 3,
		'css_nav_typo_size'              => 14,
		'css_nav_drop_typo_size'         => 13,
		'css_nav_typo_transform'         => 'uppercase',
		'css_nav_typo_spacing'           => '.01',
		'css_nav_space'                  => 20,
		'css_nav_arrow_color_dark'       => '#bababa',

		'css_header_social_color_sd'     => '#b2b2b2',
		'css_header_social_size'         => 16,
		'css_header_social_space'        => 5,

		'header_hamburger_style'         => 'b',
		'css_header_hamburger_line'      => 2,
		'css_header_hamburger_mr'        => 25,
		'css_header_button_typo_weight'  => 'bold',
		'css_header_button_typo_lheight' => '.8',
		'css_header_button_typo_spacing' => '0.08',

		'header_offcanvas_desktop_menu'  => 1,
	],

	'prime-mag' => [
		'header_items_top_left'  => ['ticker'],
		'header_items_top_right' => ['social-icons'],
		'header_scheme_top'      => 'light',

		'header_items_mid_left'  => ['logo'],
		'header_items_mid_right' => ['text'],
		'header_scheme_mid'      => 'light',

		'header_items_bot_left'  => ['hamburger', 'nav-menu'],
		'header_items_bot_right' => ['search'],
		'header_width_bot'       => 'contain',

		'css_header_c_shadow'    => 'rgba(10,10,10,0.06)',
		'css_header_height_top'  => 38,
		'css_header_height_mid'  => 110,
		'css_header_height_bot'  => 52,
		'css_header_border_bottom_bot' => 2,
		'css_header_c_border_bot_bot'  => '--c-main',
		'css_header_hamburger_scale'   => '.65',
		'css_header_bg_top'      => '#f2f2f2',
		'css_header_bg_sd_top'   => '#595959',
		'css_nav_space'          => 16,
		'css_nav_typo_spacing'   => '.011',
		'css_nav_typo_size'      => 15,
		'css_nav_typo_weight'    => 500,
		'css_nav_hover_dark'     => "#ffffff",
		'css_hov_bg_dark'        => 'rgba(255,255,255,0.1)',
		'css_header_social_size' => 15,

		'header_mob_scheme_mid'  => 'light',

		'header_offcanvas_scheme' => 'light',
		'header_offcanvas_desktop_menu' => 1,
	],

	'financial' => [
		'header_layout'           => 'smart-b',
		'header_items_mid_left'   => ['social-icons'],
		'header_items_mid_center' => ['logo'],
		'header_items_mid_right'  => ['button'],
		'header_items_bot_left'   => ['hamburger'],
		'header_items_bot_center' => ['nav-menu'],
		'header_items_bot_right'  => ['search'],
		'header_scheme_bot'       => 'light',
		
		'header_social_style'     => 'b',

		'css_header_height_bot'          => 66,
		'css_header_border_bottom_bot'   => 1,
		'css_header_c_border_bot_bot'    => '#e2e2e2',
		'css_header_c_border_bot_sd_bot' => '#222',
		'css_nav_typo_weight'            => 'bold',
		'css_nav_typo_size'              => 16,
		'css_nav_typo_spacing'           => '0.04',
		'css_nav_arrow_color_light'      => '#565656',

		'css_header_c_shadow' => 'rgba(10,10,10,0.03)',
		'header_offcanvas_desktop_menu' => 1
	],

	'citybuzz' => [
		'header_width'            => 'full',
		'header_items_mid_left'   => ['logo'],
		'header_items_mid_center' => ['nav-menu'],
		'header_social_style'     => 'b',
		'header_search_overlay_scheme '  => 'light',

		'css_header_height_mid'          => 80,
		'css_header_grad_mid'            => 1,
		'css_header_grad_mid_c1'         => '#7b4397',
		'css_header_grad_mid_c2'         => '#dc2430',
		'css_header_c_shadow'            => '#eaeaea',
		'css_nav_typo_size'              => 13,
		'css_nav_typo_weight'            => 'bold',
		'css_nav_typo_spacing'           => '0.03',
		'css_nav_typo_transform'         => 'uppercase',
		'css_nav_hover_dark'             => '#ff9191',
		'css_drop_bg_dark'               => '#982f5b',
		'css_header_social_color_sd'     => 'rgba(255,255,255,0.9)',
		'css_header_social_hov_color_sd' => '#ffffff',
		'css_header_social_size'         => 17,
		'css_header_search_hov_color_sd' => '#fff',
		'css_header_offcanvas_bg_sd'     => '#140010',
		'css_mega_menu_inherit_hover'    => 1,

		'css_header_mob_grad_mid'        => 1,
		'css_header_mob_grad_mid_c1'     => '#7b4397',
		'css_header_mob_grad_mid_c2'     => '#dc2430',
	],

	'coinbase' => [
		'header_items_top_left'     => ['nav-small'],
		'header_items_top_right'    => ['social-icons'],
		'header_items_mid_left'     => ['logo'],
		'header_items_mid_center'   => ['nav-menu'],
		'header_items_mid_right'    => ['scheme-switch', 'search'],

		'css_header_height_top'         => 30,
		'css_header_height_mid'         => 85,
		'css_header_bg_sd_top'          => '#142135',
		'css_header_bg_sd_mid'          => '#152844',
		'css_nav_typo_spacing'          => '0.02',
		'css_nav_small_first_nopad'     => 1,
		'css_drop_bg_dark'              => '11223d',

		'css_header_mob_bg_sd_mid'      => '#142135',
		'css_header_offcanvas_bg_sd'    => '#142135'
	],

	'pro-mag' => [
		'header_items_top_left'     => ['hamburger', 'nav-small'],
		'header_items_top_right'    => ['social-icons', 'search'],
		'header_items_mid_left'     => ['logo'],
		'header_items_mid_right'    => ['nav-menu', 'scheme-switch'],
		'header_scheme_mid'         => 'light',

		'css_header_height_top'         => 38,
		'css_header_height_mid'         => 76,
		'css_header_bg_sd_top'          => '#0a0505',
		'css_header_c_shadow'           => 'rgba(0,0,0,0.05)',
		'css_header_hamburger_scale'    => '0.75',
		'css_nav_typo_weight'           => 'bold',
		
		'header_offcanvas_desktop_menu' => 1,
	],

	'health' => [
		'header_items_mid_left'     => ['logo'],
		'header_items_mid_right'    => ['nav-small', 'social-icons', 'button'],
		'header_items_bot_left'     => ['hamburger', 'nav-menu'],
		'header_items_bot_right'    => ['search'],
		'header_scheme_mid'         => 'light',
		'header_scheme_bot'         => 'light',

		'header_mob_scheme_mid'     => 'light',

		'css_header_height_mid'         => 100,
		'css_header_border_top_mid'     => 4,
		'css_header_c_border_top_mid'   => '--c-main',
		'css_header_border_top_bot'     => 1,
		'css_header_hamburger_scale'    => '0.85',
		'css_nav_small_typo_spacing'    => '-0.01',
		'css_nav_typo_size'             => 14,
		'css_nav_space'                 => 16,
		'css_nav_arrow_color_light'     => '#9b9b9b',
		'css_header_c_shadow'           => 'rgba(0,0,0,0.05)',
		
		'css_header_mob_border_top_mid'   => 4,
		'css_header_mob_c_border_top_mid' =>  '--c-main',
	],

	'game-zone' => [
		'header_items_top_left'     => ['nav-small'],
		'header_items_top_right'    => ['social-icons'],
		'header_items_mid_left'     => ['logo'],
		'header_items_mid_right'    => ['text'],
		'header_items_bot_left'     => ['hamburger', 'nav-menu'],
		'header_items_bot_right'    => ['scheme-switch', 'search'],
		'header_social_services'    => ['facebook', 'twitter', 'instagram', 'youtube'],

		'css_header_height_top'         => 34,
		'css_header_bg_sd_top'          => '#111111',
		'css_header_border_bottom_top'  => 1,
		'css_header_height_mid'         => 120,
		'css_header_bg_sd_mid'          => '#060606',
		'css_header_height_bot'         => 52,
		'css_header_bg_sd_bot'          => '--c-main',
		'css_nav_typo_size'             => 16,
		'css_nav_typo_weight'           => 'bold',
		'css_nav_typo_spacing'          => '0.03',
		'css_nav_space'                 => 16,
		'css_nav_hover_dark'            => '#ffffff',
		'css_nav_color_dark'            => '#f7f7f7',
		'css_header_hamburger_scale'    => '0.7',
		'css_nav_small_first_nopad'     => 1,
		'css_nav_small_typo_size'       => 12,
		'css_nav_small_typo_weight'     => 600,
		'css_nav_small_typo_transform'  => 'uppercase',
		'css_nav_small_color_dark'      => 'rgba(255,255,255,0.59)',
		'css_header_search_hov_color_sd'    => '#ffffff',
		'css_header_switcher_hov_color_sd'  => '#ffffff',
		'css_header_hamburger_hov_color_sd' => '#ffffff',
	],

	'mag-studio' => [
		'header_items_top_left'     => ['nav-small'],
		'header_items_top_right'    => ['social-icons', 'scheme-switch'],
		'header_items_mid_left'     => ['logo'],
		'header_items_mid_right'    => ['text'],
		'header_items_bot_left'     => ['hamburger', 'nav-menu'],
		'header_items_bot_right'    => ['search'],
		'header_scheme_mid'         => 'light',
		'header_scheme_bot'         => 'light',

		'css_header_c_shadow'           => 'rgba(0,0,0,0.05)',
		'css_header_height_top'         => 40,
		'css_header_grad_top'           => 1,
		'css_header_grad_top_c1'        => '#c2113c',
		'css_header_grad_top_c2'        => '#f4be3e',
		'css_header_height_mid'         => 125,
		'css_header_inner_pad_mid'      => ['main' => ['top' => 20], 'medium' => [], 'limit' => 0],
		'css_header_height_bot'         => 52,
		'css_header_border_top_bot'     => 0,
		'css_header_border_bottom_bot'  => 0,
		'css_nav_typo_size'             => 15,
		'css_nav_typo_weight'           => 'bold',
		'css_nav_typo_spacing'          => '0.005',
		'css_header_hamburger_scale'    => '0.75',
		'css_header_hamburger_color'    => '--c-main',
		'css_header_social_color_sd'    => '#ffffff',
		'css_nav_small_color_dark'      => 'rgba(255,255,255,0.92)',
		'css_nav_small_hover_dark'      => '#ffffff',
		'css_nav_space'                 => 16,
		'css_nav_small_first_nopad'     => 1,
	],

	'fitness' => [
		'header_layout'                     => 'smart-b',
		'header_items_mid_left'             => ['social-icons'],
		'header_items_mid_center'           => ['logo'],
		'header_items_mid_right'            => ['button'],
		'header_items_bot_left'             => ['hamburger'],
		'header_items_bot_center'           => ['nav-menu'],
		'header_items_bot_right'            => ['scheme-switch','search'],
		'header_scheme_bot'                 => 'light',
		'header_social_style'               => 'b',
		'css_header_height_mid'             => '100',
		'css_header_height_bot'             => '54',
		'css_header_border_top_bot'         => '3',
		'css_header_c_border_top_bot'       => '--c-main',
		'css_header_border_bottom_bot'      => '1',
		'css_header_c_border_bot_bot'       => '#e2e2e2',
		'css_header_c_border_bot_sd_bot'    => '#222222',
		'css_header_hamburger_line'         => '2',
		'css_header_hamburger_height'       => '14',
		'css_nav_typo_size'                 => '14',
		'css_nav_typo_weight'               => 'bold',
		'css_nav_typo_spacing'              => '0.02',
		'css_header_social_color_sd'        => 'rgba(255,255,255,0.94)',
		'css_header_social_hov_color_sd'    => '#ffffff',
		'css_header_mob_height_mid'         => '70',
		'css_header_mob_border_bottom_mid'  => '3',
		'css_header_mob_c_border_bot_mid'   => '--c-main'
	],

	'gossip-mag' => [
		'header_layout'                     => 'smart-b',
		'header_width'                      => 'full',
		'header_items_mid_left'             => ['hamburger','logo'],
		'header_items_mid_center'           => ['nav-menu'],
		'header_scheme_mid'                 => 'light',
		'header_social_style'               => 'b',
		'header_mob_scheme_top'             => 'light',
		'header_mob_scheme_mid'             => 'light',

		'css_header_c_shadow'               => 'rgba(0,0,0,0.07)',
		'css_header_border_top_mid'         => '4',
		'css_header_height_mid'             => '94',
		'css_header_c_border_top_mid'       => '--c-main',
		'css_nav_typo_size'                 => '14',
		'css_nav_typo_weight'               => 'bold',
		'css_nav_typo_spacing'              => '.06',
		'css_nav_drop_typo_weight'          => '500',
		'css_header_social_size'            => '16',
		'css_header_social_box_size'        => '36',
		'css_header_mob_border_top_mid'     => '4',
		'css_header_mob_c_border_top_mid'   => '--c-main'
	],

	'news-board' => [
		'header_layout'                     => 'smart-b',
		'header_items_mid_left'             => ['social-icons'],
		'header_items_mid_center'           => ['logo'],
		'header_items_mid_right'            => ['button'],
		'header_scheme_mid'                 => 'light',
		'header_items_bot_left'             => ['hamburger'],
		'header_items_bot_center'           => ['nav-menu'],
		'header_items_bot_right'            => ['scheme-switch','search'],
		'header_scheme_bot'                 => 'light',
		'header_social_style'               => 'b',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'css_header_border_top_bot'         => '1',
		'css_header_c_border_top_bot'       => '#ededed',
		'css_header_c_border_top_sd_bot'    => '#2d2d2d',
		'css_header_c_shadow'               => 'rgba(0,0,0,0.07)',
		'css_nav_typo_spacing'              => '0.05'		
	],

	'news-time' => [
		'header_items_top_left'             => ['ticker'],
		'header_items_top_right'            => ['social-icons','search'],
		'header_scheme_top'                 => 'light',
		'header_items_mid_left'             => ['logo'],
		'header_items_mid_right'            => ['text'],
		'header_scheme_mid'                 => 'light',
		'header_items_bot_left'             => ['nav-menu'],
		'header_width_bot'                  => 'contain',
		'header_mob_scheme_mid'             => 'light',
		'header_offcanvas_scheme'           => 'light',
		'header_offcanvas_desktop_menu'     => '1',
		'header_layout'                     => 'smart-legacy',
		'header_nav_hov_style'              => 'b',
		'header_social_style'               => 'c',
		'header_search_type'                => 'form',
		'header_items_bot_right'            => ['scheme-switch','hamburger'],
		'header_sticky_full'                => '1',
		'css_header_ticker_label_margins'   => ['main' => ['right' => '28'],'medium' => '','limit' => '0'],
		'css_header_hamburger_width'        => '15',
		'css_header_hamburger_height'       => '13',
		'header_hamburger_style'            => 'b',
		'css_header_offcanvas_menu_typo_size' => ['main' => '15','medium' => '','small' => '','limit' => '0']			
	],

	'smart-times' => [

		'header_items_mid_right'            => ['button'],
		'header_width'                      => 'full',
		'header_items_top_left'             => ['ticker'],
		'header_items_top_right'            => ['nav-small'],
		'header_items_mid_left'             => ['social-icons'],
		'header_items_mid_center'           => ['logo'],
		'header_scheme_mid'                 => 'light',
		'header_items_bot_left'             => ['date'],
		'header_items_bot_center'           => ['nav-menu'],
		'header_items_bot_right'            => ['search','hamburger'],
		'header_scheme_bot'                 => 'light',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'header_social_style'               => 'b',
		'header_hamburger_style'            => 'b',
		'header_offcanvas_desktop_menu'     => '1',

		'css_header_height_mid'             => '96',
		'css_header_height_bot'             => '51',
		'css_header_border_top_bot'         => '1',
		'css_header_border_bottom_bot'      => '2',
		'css_header_c_border_top_bot'       => '#e8e8e8',
		'css_header_c_border_bot_bot'       => '#dedede',
		'css_header_ticker_label_color'     => '#f7f7f7',
		'css_header_ticker_label_typo_size' => ['main' => '13.8','medium' => '','small' => '','limit' => '0'],
		'css_header_ticker_label_typo_weight' => '600',
		'css_header_ticker_label_typo_spacing' => ['main' => '.02','medium' => '','small' => '','limit' => '0'],
		'css_header_ticker_max_width'       => ['main' => '500','large' => '400','medium' => '','limit' => '0'],
		'css_nav_typo_size'                 => '14.4',
		'css_nav_typo_weight'               => '600',
		'css_nav_space'                     => '16',
		'css_header_ticker_typo_size'       => ['main' => '13.8','medium' => '','small' => '','limit' => '0'],
		'css_header_ticker_label_margins'   => ['main' => ['right' => '30'],'medium' => '','limit' => '0'],
		'css_header_social_size'            => '17',
		'css_header_social_box_size'        => '37',
		'css_nav_drop_typo_size'            => '13',
		'css_header_hamburger_width'        => '18',
		'css_header_offcanvas_menu_typo_size' => ['main' => '15','medium' => '','small' => '','limit' => '0']
	],

	'tech-drop' => [
		'header_scheme_mid'                 => 'light',
		'header_items_mid_right'            => ['social-icons', 'search', 'scheme-switch'],
		'header_mob_items_mid_right'        => ['scheme-switch','search'],
		'css_header_height_mid'             => '80',
		'css_header_c_shadow'               => 'rgba(114,114,114,0.15)',
		'css_header_social_size'            => '15',
		'css_header_search_mr'              => '7',
		'css_header_mob_search_size'        => '18',
		'css_header_mob_hamburger_scale'    => '.8'
	],

	'blogger' => [
		'header_items_mid_left'             => ['logo'],
		'header_items_mid_right'            => ['nav-small','social-icons','button'],
		'header_scheme_mid'                 => 'light',
		'header_items_bot_left'             => ['hamburger','nav-menu'],
		'header_items_bot_right'            => ['search','scheme-switch'],
		'header_button_text'                => 'SUBSCRIBE',
		'header_button_link'                => '#',
		'header_button_style'               => 'a',
		'css_header_height_mid'             => '100',
		'css_header_c_border_top_mid'       => '--c-main',
		'css_header_bg_sd_bot'              => '--c-main',
		'css_header_border_top_bot'         => '0',
		'css_header_hamburger_scale'        => '0.8',
		'css_nav_hover_dark'                => '#eaeaea',
		'css_nav_small_typo_weight'         => '600',
		'css_nav_color_dark'                => '#f9f9f9',
		'css_drop_bg_dark'                  => '#72103a',
		'css_header_search_hov_color_sd'    => '#ffffff',
		'css_header_switcher_hov_color_sd'  => '#ffffff',
		'css_header_hamburger_hov_color_sd' => '#ffffff',
		'css_header_bg_sd_mid'              => '#0b0e23',
		'css_header_offcanvas_bg_sd'        => '#19010d'
	],

	'tech-blog' => [
		'header_items_top_left'             => ['nav-small'],
		'header_items_top_right'            => ['social-icons'],
		'header_items_mid_right'            => ['button', 'scheme-switch', 'search'],
		'header_scheme_mid'                 => 'light',
		'header_items_mid_left'             => ['hamburger', 'logo', 'nav-menu'],
		'header_hamburger_style'            => 'b',
		'header_nav_hov_style'              => 'b',
		'header_social_services'            => ['facebook','twitter','instagram','pinterest','vimeo'],
		'header_social_style'               => 'b',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'css_header_height_top'             => '42',
		'css_header_c_shadow'               => 'rgba(0,0,0,0.02)',
		'css_header_border_grad_top'        => '1',
		'css_header_border_grad_top_width'  => '3',
		'css_header_border_grad_top_pos'    => 'bottom',
		'css_header_border_grad_top_c1'     => '#e40666',
		'css_header_border_grad_top_c2'     => '#3c3fde',
		'css_header_height_mid'             => '70',
		'css_header_border_bottom_mid'      => '1',
		'css_header_c_border_bot_mid'       => '#efefef',
		'css_header_c_border_bot_sd_mid'    => '#3f3f3f',
		'css_nav_typo_size'                 => '15.4',
		'css_nav_typo_spacing'              => '0.01',
		'css_nav_arrow_color_light'         => '--c-main',
		'css_header_social_size'            => '13',
		'css_header_social_box_size'        => '26',
		'css_header_social_space'           => '5',
		'css_header_social_color_sd'        => '#ffffff',
		'css_header_social_hov_color_sd'    => 'rgba(255,255,255,0.92)',
		'css_header_hamburger_hov_color_sd' => '#bcbcbc',
		'css_header_button_typo_size'       => '12',
		'css_header_button_bradius'         => '6',
		'css_header_button_height'          => ['main' => '34','medium' => '','small' => '','limit' => '0'],
		'css_header_button_pad'             => ['main' => ['right' => '14','left' => '14'],'medium' => '','small' => '','limit' => '0'],
		'css_header_search_hov_color_sd'    => '#bcbcbc',
		'css_header_search_size'            => '18',
		'css_nav_small_first_nopad'         => '1',
		'css_nav_space'                     => '15',
		'css_nav_small_hover_dark'          => 'rgba(255,255,255,0.76)',
		'css_nav_hov_b_line_equal'          => '1',
		'css_header_mob_border_grad_mid'    => '1',
		'css_header_mob_border_grad_mid_width' => '3',
		'css_header_mob_border_grad_mid_c1' => '#e40666',
		'css_header_mob_border_grad_mid_c2' => '#3c3fde'
	],

	'friday-mag' => [
		'header_layout'                     => 'smart-b',
		'header_items_top_left'             => ['hamburger'],
		'header_items_top_center'           => ['nav-menu'],
		'header_items_top_right'            => ['search'],
		'header_scheme_top'                 => 'light',
		'header_items_mid_left'             => ['social-icons'],
		'header_items_mid_center'           => ['logo'],
		'header_items_mid_right'            => ['button'],
		'header_items_bot_center'           => ['text','nav-small'],
		'header_scheme_bot'                 => 'light',
		'header_width_bot'                  => 'contain',
		'header_offcanvas_desktop_menu'     => '1',
		'header_social_services'            => ['facebook','twitter','instagram','pinterest'],
		'header_social_style'               => 'b',
		'header_button_text'                => 'Subscribe Now',
		'header_button_style'               => 'a',
		'header_text'                       => 'HOT TOPICS',
		'css_header_height_mid'             => '100',
		'css_header_height_top'             => '60',
		'css_header_bg_top'                 => '#ffffff',
		'css_header_bg_sd_mid'              => '#12232e',
		'css_header_c_border_top_bot'       => '#ededed',
		'css_header_c_border_top_sd_bot'    => '#4f4f4f',
		'css_header_border_bottom_bot'      => '1',
		'css_header_c_border_bot_bot'       => '#d3d3d3',
		'css_nav_font'                      => '_primary',
		'css_nav_typo_weight'               => 'bold',
		'css_nav_typo_spacing'              => '0.05',
		'css_nav_small_font'                => '_primary',
		'css_nav_small_typo_size'           => '15',
		'css_nav_small_typo_weight'         => '500',
		'css_header_hamburger_scale'        => '0.70',
		'css_header_button_color_sd'        => '#11242d',
		'css_header_button_bg_sd'           => '--c-main',
		'css_header_button_bradius'         => '6',
		'css_header_text_typo_family'       => '_primary',
		'css_header_text_typo_size'         => ['main' => '14','medium' => '','small' => '','limit' => '0'],
		'css_header_text_typo_weight'       => 'bold',
		'css_header_text_color'             => '#dfaa3d',
		'codes_wrap_header_before'          => '1',
		'css_codes_bg_header_before'        => '#02001c',
		'css_header_search_size_top'        => '16',
		'css_header_offcanvas_bg'           => '#060d11',
		'css_header_social_size'            => '18'
	],

	'smart-post' => [
		'header_layout'                     => 'smart-b',
		'header_items_top_left'             => ['hamburger','nav-small'],
		'header_items_top_right'            => ['social-icons','search'],
		'header_items_mid_right'            => ['button'],
		'header_scheme_bot'                 => 'light',
		'header_nav_hov_style'              => 'b',
		'header_offcanvas_desktop_menu'     => '1',
		'header_social_services'            => ['facebook','twitter','instagram','pinterest','youtube'],
		'header_social_style'               => 'b',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'css_header_height_mid'             => '90',
		'css_header_bg_sd_mid'              => '#92113b',
		'css_header_c_border_bot_bot'       => '#e2e2e2',
		'css_nav_typo_size'                 => '14',
		'css_nav_typo_weight'               => '600',
		'css_nav_typo_spacing'              => '0.07',
		'css_nav_drop_typo_size'            => '15',
		'css_nav_space'                     => '14',
		'css_nav_arrow_color_light'         => '#565656',
		'css_nav_arrow_color_dark'          => '#ffb5b5',
		'css_hov_bg_dark'                   => 'rgba(255,255,255,0)',
		'css_header_mob_bg_mid'             => '#92113b',
		'css_header_mob_border_bottom_mid'  => '0',
		'css_header_offcanvas_menu_typo_transform' => 'uppercase',
		'css_header_offcanvas_menu_typo_spacing' => ['main' => '.05','medium' => '','small' => '','limit' => '0'],
		'css_header_social_color_sd'        => 'rgba(255,255,255,0.9)',
		'css_header_social_hov_color_sd'    => '#e5e5e5',
		'css_header_social_size'            => '12',
		'css_header_social_box_size'        => '28',
		'css_header_search_color_sd'        => '#ffffff',
		'css_header_hamburger_scale'        => '0.7',
		'css_header_button_typo_size'       => '13',
		'css_header_button_typo_spacing'    => '0.11',
		'css_header_button_bg_sd'           => 'rgba(255,255,255,0.27)',
		'codes_wrap_header_before'          => '1',
		'css_codes_bg_header_before'        => '#2d2d2d',
		'css_nav_small_typo_size'           => '14',
		'css_nav_small_hover'               => '#cecece',
		'css_nav_color_dark'                => '#f9f9f9',
		'css_header_offcanvas_menu_typo_size' => ['main' => '14','medium' => '','small' => '','limit' => '0']
	],
	
	'world-mag' => [
		'header_width'                      => 'full',
		'header_items_mid_right'            => ['social-icons','button'],
		'css_header_height_mid'             => '100',
		'css_header_bg_mid'                 => '#090620',
		'header_nav_hov_style'              => 'b',
		'css_nav_typo_size'                 => '16',
		'css_nav_typo_weight'               => 'bold',
		'css_nav_typo_spacing'              => '0.01',
		'css_nav_space'                     => '15',
		'css_nav_hov_b_weight'              => '3',
		'css_nav_hov_b_line_equal'          => '1',
		'header_social_style'               => 'b',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'header_social_services'            => ['facebook','twitter','instagram','youtube'],
		'css_drop_bg_dark'                  => '#060416'
	],

	'everyday-news' => [
		'header_items_mid_left'             => ['logo','date'],
		'header_items_mid_right'            => ['nav-small','social-icons','button'],
		'css_header_grad_mid'               => '1',
		'css_header_grad_mid_c1'            => '#8e44ad',
		'css_header_grad_mid_c2'            => '#f80759',
		'css_header_height_mid'             => '80',
		'css_header_c_border_top_mid'       => '--c-main',
		'header_items_bot_left'             => ['hamburger','nav-menu'],
		'header_items_bot_right'            => ['search','scheme-switch'],
		'header_scheme_bot'                 => 'light',
		'css_header_bg_sd_bot'              => '#1e1521',
		'css_header_border_top_bot'         => '0',
		'header_offcanvas_desktop_menu'     => '1',
		'css_header_offcanvas_bg_sd'        => '#0f0007',
		'header_nav_small_menu'             => '566',
		'css_nav_small_typo_weight'         => '500',
		'css_header_hamburger_scale'        => '0.75',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'css_header_button_color'           => '#f80759',
		'css_header_button_bg'              => '#ffffff',
		'css_header_mob_grad_mid'           => '1',
		'css_header_mob_grad_mid_c1'        => '#8e44ad',
		'css_header_mob_grad_mid_c2'        => '#f80759',
		'css_header_social_color_sd'        => 'rgba(255,255,255,0.8)',
		'css_header_social_hov_color_sd'    => '#ffffff',
		'css_nav_small_hover_dark'          => '#ffffff'
	],

	'morning-post' => [
		'header_layout'                     => 'smart-b',
		'css_header_c_shadow'               => 'rgba(10,10,10,0.06)',
		'header_items_top_left'             => ['hamburger'],
		'header_items_top_center'           => ['nav-menu'],
		'header_items_top_right'            => ['search'],
		'header_scheme_top'                 => 'light',
		'css_header_height_top'             => '60',
		'css_header_bg_top'                 => '#ffffff',
		'css_header_bg_top_sd'              => '#000',
		'header_items_mid_left'             => ['social-icons'],
		'header_items_mid_center'           => ['logo'],
		'header_items_mid_right'            => ['button'],
		'css_header_height_mid'             => '100',
		'css_header_bg_sd_mid'              => '#5151f7',
		'header_items_bot_center'           => ['text','nav-small'],
		'header_scheme_bot'                 => 'light',
		'header_width_bot'                  => 'contain',
		'css_header_height_bot'             => '50',
		'css_nav_font'                      => '_primary',
		'css_nav_typo_weight'               => 'bold',
		'css_nav_typo_spacing'              => '0.05',
		'header_offcanvas_desktop_menu'     => '1',
		'css_header_offcanvas_bg'           => '#060d11',
		'header_nav_small_menu'             => '60',
		'css_nav_small_font'                => '_primary',
		'css_nav_small_typo_size'           => '14',
		'css_nav_small_typo_weight'         => '600',
		'header_social_services'            => ['facebook','twitter','instagram','pinterest'],
		'header_social_style'               => 'b',
		'css_header_social_hov_color_sd'    => '#66cbff',
		'css_header_social_size'            => '18',
		'css_header_search_size_top'        => '16',
		'css_header_hamburger_scale'        => '0.70',
		'header_button_text'                => 'Subscribe Now',
		'header_button_style'               => 'a',
		'css_header_button_color_sd'        => '#ffffff',
		'css_header_button_bg_sd'           => 'rgba(255,255,255,0.18)',
		'css_header_button_bradius'         => '6',
		'header_text'                       => 'HOT TOPICS',
		'css_header_text_typo_family'       => '_primary',
		'css_header_text_typo_size'         => ['main' => '14','medium' => '','small' => '','limit' => '0'],
		'css_header_text_typo_weight'       => '800',
		'css_header_text_color'             => '#0a0000',
		'css_header_text_color_sd'          => '#fff',
		'codes_wrap_header_before'          => '1',
		'css_codes_bg_header_before'        => '#02001c',
		'css_nav_typo_size'                 => '13.5'
	],

	'cup-of-coffee' => [
		'header_layout'                     => 'smart-b',
		'css_header_c_shadow'               => 'rgba(38,38,38,0.16)',
		'header_items_mid_left'             => ['logo'],
		'header_scheme_mid'                 => 'light',
		'header_items_mid_right'            => ['nav-small','social-icons'],
		'css_header_height_mid'             => '100',
		'header_items_bot_left'             => ['hamburger','nav-menu'],
		'header_items_bot_right'            => ['button'],
		'header_scheme_bot'                 => 'light',
		'css_header_height_bot'             => '54',
		'css_nav_typo_size'                 => '14',
		'css_nav_typo_weight'               => 'bold',
		'css_nav_typo_spacing'              => '0.02',
		'header_nav_small_menu'             => '566',
		'css_nav_small_first_nopad'         => '1',
		'css_nav_small_space'               => '7',
		'header_social_services'            => ['facebook','twitter','instagram','pinterest'],
		'header_social_style'               => 'b',
		'css_header_social_size'            => '16',
		'css_header_social_box_size'        => '32',
		'css_header_hamburger_line'         => '2',
		'css_header_hamburger_height'       => '14',
		'header_button_text'                => 'Subscribe',
		'css_header_button_color'           => '--c-main',
		'css_header_button_bc'              => '--c-main',
		'css_header_button_bradius'         => '4',
		'css_header_button_height'          => ['main' => '32','medium' => '','small' => '','limit' => '0'],
		'header_mob_scheme_mid'             => 'light',
		'header_offcanvas_scheme'           => 'light',
		'css_header_button_color_hov'       => '#ffffff',
		'css_header_button_color_sd'        => '#ffffff',
		'css_header_button_bc_sd'           => 'rgba(255,255,255,0.41)'
	],

	'family-mag' => [
		'header_items_mid_left'             => ['logo'],
		'header_items_mid_right'            => ['social-icons','button'],
		'css_header_grad_mid'               => '1',
		'css_header_grad_mid_c1'            => '#000000',
		'css_header_grad_mid_c2'            => '#930e0e',
		'css_header_height_mid'             => '90',
		'header_items_bot_left'             => ['hamburger','nav-menu'],
		'header_items_bot_right'            => ['search'],
		'header_scheme_bot'                 => 'light',
		'css_header_bg_sd_bot'              => '#1e1521',
		'header_offcanvas_desktop_menu'     => '1',
		'css_header_offcanvas_bg_sd'        => '#0f0007',
		'header_nav_small_menu'             => '566',
		'css_nav_small_typo_weight'         => '500',
		'css_header_hamburger_scale'        => '0.75',
		'header_button_text'                => 'Subscribe Now',
		'header_button_style'               => 'a',
		'css_header_button_color'           => '#ffffff',
		'css_header_button_bg'              => '#ffffff',
		'css_header_mob_grad_mid'           => '1',
		'css_header_mob_grad_mid_c1'        => '#0a0202',
		'css_header_mob_grad_mid_c2'        => '#930e0e',
		'css_header_social_color_sd'        => 'rgba(255,255,255,0.8)',
		'css_header_social_hov_color_sd'    => '#ffffff',
		'css_nav_small_hover_dark'          => '#ffffff',
		'header_layout'                     => 'smart-b',
		'css_header_grad_mid_pos1'          => '20',
		'css_header_height_bot'             => '66',
		'css_nav_typo_size'                 => '15',
		'css_nav_typo_weight'               => 'bold',
		'css_nav_typo_spacing'              => '0.07',
		'header_social_style'               => 'b',
		'css_header_button_bg_sd'           => '--c-main',
		'css_header_button_typo_spacing'    => '0.13',
		'css_header_button_typo_size'       => '13'
	],

	'lazy-busy' => [
		'header_layout'                     => 'smart-b',
		'header_items_mid_left'             => ['hamburger','date'],
		'header_items_mid_center'           => ['logo'],
		'header_items_mid_right'            => ['search','social-icons'],
		'header_scheme_mid'                 => 'light',
		'css_header_height_mid'             => '80',
		'header_items_bot_left'             => ['nav-menu'],
		'header_items_bot_right'            => ['button2','button'],
		'header_offcanvas_scheme'           => 'light',
		'header_social_services'            => ['facebook','twitter','instagram','youtube'],
		'header_social_style'               => 'b',
		'css_header_hamburger_scale'        => '0.85',
		'header_button_text'                => 'Buy Now',
		'header_button_style'               => 'a',
		'css_header_button_bg'              => '--c-main',
		'css_header_button_bradius'         => '4',
		'css_header_button_height'          => ['main' => '30','medium' => '','small' => '','limit' => '0'],
		'header_button2_text'               => 'Latest From Tech',
		'header_button2_style'              => 'a',
		'css_header_button2_bg'             => '#303030',
		'css_header_button2_bradius'        => '4',
		'css_header_button2_height'         => ['main' => '30','medium' => '','small' => '','limit' => '0'],
		'header_button3_text'               => 'Subscribe',
		'css_header_button3_bradius'        => '4',
		'css_header_button3_height'         => ['main' => '32','medium' => '','small' => '','limit' => '0'],
		'css_header_button3_typo_size'      => '12',
		'css_header_button3_typo_spacing'   => '0.04',
		'css_header_hamburger_mr'           => '30',
		'css_header_social_size'            => '16',
		'css_header_social_box_size'        => '32',
		'css_header_search_mr'              => '14',
		'css_nav_first_nopad'               => '1',
	],

	'national-press' => [
		'css_header_c_shadow'               => 'rgba(0,0,0,0.05)',
		'header_items_top_left'             => ['nav-small'],
		'header_items_top_right'            => ['social-icons','scheme-switch','search'],
		'css_header_height_top'             => '25',
		'css_header_bg_top'                 => '#0c122b',
		'header_items_mid_left'             => ['hamburger','date'],
		'header_items_mid_center'           => ['logo'],
		'header_items_mid_right'            => ['button'],
		'css_header_height_mid'             => '85',
		'css_header_bg_mid'                 => '#0a1633',
		'header_items_bot_center'           => ['nav-menu'],
		'css_header_height_bot'             => '40',
		'css_header_bg_bot'                 => '#0a1633',
		'css_header_border_top_bot'         => '1',
		'css_header_c_border_top_bot'       => '#304951',
		'css_nav_typo_size'                 => '13',
		'css_nav_typo_weight'               => 'normal',
		'css_nav_typo_transform'            => 'uppercase',
		'css_nav_typo_spacing'              => '0.14',
		'css_nav_arrow_color_light'         => '#353535',
		'header_mob_items_mid_right'        => ['search','hamburger'],
		'header_offcanvas_desktop_menu'     => '1',
		'css_nav_small_color_dark'          => 'rgba(255,255,255,0.92)',
		'css_nav_small_hover_dark'          => '#fff',
		'css_header_social_color'           => '#fff',
		'css_header_social_hov_color'       => '#f2f2f2',
		'header_search_overlay_scheme'      => '',
		'css_header_search_hov_color'       => '#f2f2f2',
		'css_header_switcher_hov_color'     => '#f2f2f2',
		'css_header_hamburger_scale'        => '0.75',
		'header_button_text'                => 'SUBSCRIBE',
		'header_button_style'               => 'a',
		'css_header_button_typo_weight'     => 'normal',
		'css_header_button_typo_spacing'    => '0.11',
		'css_header_button_height'          => ['main' => '32','medium' => '','small' => '','limit' => '0'],
		'header_nav_small_menu'             => '60',
		'css_nav_arrow_color_dark'          => '#6e769b',
		'css_nav_small_first_nopad'         => '1',
		'header_mob_items_mid_center'       => [],
		'header_mob_items_mid_left'         => ['logo'],
		'css_drop_bg_dark'                  => '#0a1633',
		'css_header_mob_bg_sd_mid'          => '#0a1633',
		'css_header_mob_hamburger_color_sd' => 'rgba(255,255,255,0.85)',
		'css_header_mob_hamburger_line'     => '2',
		'css_header_offcanvas_bg_sd'        => '#080f22',
		'css_header_mob_search_size'        => '19',
		'css_header_mob_search_mr'          => '11',
		'header_mob_is_scroller_bot'        => '1',
		'header_mob_items_bot_left'         => ['nav-scroll'],
		'header_mob_nav_scroll_menu'        => '55',
		'css_header_mob_height_bot'         => '40',
		'css_header_mob_bg_bot'             => '#0a1633',
		'css_header_mob_c_border_top_bot'   => '#304951',
		'css_nav_scroll_typo_size'          => '13',
		'css_nav_scroll_typo_weight'        => 'normal',
		'css_nav_scroll_typo_spacing'       => '0.14',
		'css_nav_scroll_space'              => '12'
	],

	'new-one24' => [
		'header_items_top_center'           => ['text'],
		'header_items_top_right'            => ['nav-small','social-icons','search'],
		'css_header_height_top'             => '35',
		'css_header_bg_sd_top'              => '#0c0c0c',
		'header_items_mid_left'             => ['logo'],
		'header_items_mid_right'            => ['nav-menu','button'],
		'css_header_height_mid'             => '84',
		'css_header_grad_mid_angle'         => '-90',
		'css_header_bg_mid'                 => '#aa0000',
		'header_nav_hov_style'              => 'b',
		'css_nav_typo_size'                 => '15',
		'css_nav_space'                     => '15',
		'css_nav_hov_b_weight'              => '3',
		'css_nav_color_dark'                => '#ffffff',
		'css_nav_arrow_color_dark'          => 'rgba(255,255,255,0.48)',
		'css_drop_bg_dark'                  => '#0b1321',
		'css_drop_hov_bg_dark'              => 'rgba(255,255,255,0.03)',
		'css_header_mob_height_mid'         => '70',
		'css_header_mob_bg_sd_mid'          => '#aa0000',
		'header_offcanvas_desktop_menu'     => '1',
		'css_header_offcanvas_bg_sd'        => '#0b1321',
		'header_nav_small_menu'             => '60',
		'css_nav_small_typo_size'           => '14',
		'css_nav_small_typo_weight'         => 'bold',
		'css_nav_small_first_nopad'         => '1',
		'header_social_style'               => 'b',
		'css_header_social_size'            => '14',
		'css_header_social_box_size'        => '24',
		'header_search_overlay_scheme'      => '',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'css_header_button_typo_size'       => '14',
		'css_header_button_typo_weight'     => 'bold',
		'css_header_button_color'           => '#000114',
		'css_header_button_bg'              => '#ffe500',
		'css_header_button_bradius'         => '30',
		'css_header_button_pad'             => ['main' => ['right' => '20','left' => '20'],'medium' => '','small' => '','limit' => '0'],
		'header_text'                       => '<a href="https://theme-sphere.com/buy/go.php?theme=smartmag" target="_blank" style="color:inherit;">Buy SmartMag Now</a>',
		'css_header_text_typo_family'       => '_secondary',
		'css_header_text_typo_size'         => ['main' => '14','medium' => '','small' => '','limit' => '0'],
		'css_header_text_typo_weight'       => 'bold',
		'css_header_mob_search_size'        => '19',
		'css_hov_bg_dark'                   => 'rgba(255,255,255,0)',
		'css_header_text_color'             => '#ffe500',
		'css_header_mob_border_bottom_mid'  => '0',
		'css_header_mob_hamburger_color_sd' => 'rgba(255,255,255,0.9)',
		'css_header_mob_hamburger_hov_color_sd' => '#ffffff',
		'css_header_mob_search_color_sd'    => 'rgba(255,255,255,0.9)',
		'css_header_mob_search_hov_color'   => '#ffffff'
	],

	'thevoice-daily' => [
		'header_layout'                     => 'smart-b',
		'css_header_c_shadow'               => 'rgba(10,0,0,0.06)',
		'header_items_mid_left'             => ['logo'],
		'header_items_mid_center'           => ['nav-menu'],
		'header_items_mid_right'            => ['social-icons','button'],
		'header_width_mid'                  => 'full',
		'css_header_height_mid'             => '70',
		'css_header_bg_sd_mid'              => '#0c77e2',
		'header_items_bot_left'             => ['hamburger','text','nav-small'],
		'header_items_bot_right'            => ['search'],
		'header_scheme_bot'                 => 'light',
		'css_header_height_bot'             => '44',
		'css_header_bg_bot'                 => '#ffffff',
		'css_header_border_bottom_bot'      => '1',
		'css_nav_font'                      => '_primary',
		'css_nav_typo_size'                 => '16',
		'css_nav_typo_weight'               => '600',
		'css_nav_typo_spacing'              => '0.068',
		'css_nav_arrow_color_light'         => '#565656',
		'css_nav_hover_dark'                => '#ffffff',
		'css_header_mob_border_bottom_mid'  => '0',
		'header_offcanvas_desktop_menu'     => '1',
		'css_header_offcanvas_menu_typo_transform' => 'uppercase',
		'css_header_offcanvas_menu_typo_spacing' => ['main' => '.05','medium' => '','small' => '','limit' => '0'],
		'header_nav_small_menu'             => '337',
		'css_nav_small_typo_family'         => '_secondary',
		'css_nav_small_typo_size'           => '14',
		'css_nav_small_typo_weight'         => '600',
		'header_social_style'               => 'b',
		'css_header_social_color_sd'        => 'rgba(255,255,255,0.9)',
		'css_header_social_hov_color_sd'    => '#e5e5e5',
		'css_header_social_size'            => '17',
		'css_header_social_box_size'        => '33',
		'css_header_hamburger_color_sd'     => '#ffffff',
		'css_header_hamburger_scale'        => '0.75',
		'css_header_hamburger_mr'           => '26',
		'header_button_text'                => 'Subscribe',
		'header_button_style'               => 'a',
		'css_header_button_typo_family'     => '_primary',
		'css_header_button_typo_size'       => '14',
		'css_header_button_typo_spacing'    => '0.13',
		'css_header_button_bg_sd'           => 'rgba(255,255,255,0.15)',
		'header_text'                       => 'Trending Topics:',
		'css_header_text_typo_family'       => '_secondary',
		'css_header_text_typo_size'         => ['main' => '14','medium' => '','small' => '','limit' => '0'],
		'css_header_text_typo_weight'       => 'bold',
		'css_header_text_color'             => '--c-main',
		'css_header_mob_bg_sd_mid'          => '#0c77e2',
		'header_nav_hov_style'              => 'b',
		'css_header_max_width'              => '1920',
		'css_header_bg_sd_bot'              => '#0a0a0a',
		'header_mob_nav_scroll_menu'        => '55',
		'header_mob_items_bot_left'         => ['nav-scroll'],
		'header_mob_is_scroller_bot'        => '1',
		'header_mob_scheme_bot'             => 'light',
		'css_header_mob_bg_bot'             => '#ffffff',
		'css_header_mob_bg_sd_bot'          => '#0a0a0a',
		'css_header_mob_hamburger_color_sd' => 'rgba(255,255,255,0.91)',
		'css_header_mob_hamburger_hov_color_sd' => '#ffffff',
		'css_header_mob_search_color_sd'    => '#f9f9f9',
		'css_header_mob_search_hov_color_sd' => '#ffffff',
		'css_header_mob_search_size'        => '19',
		'css_header_social_sm_desk_hide'    => '1',
		'css_header_social_lg_hide'         => '1',
		'css_nav_arrow_color_dark'          => 'rgba(255,255,255,0.54)',
		'css_header_offcanvas_menu_typo_size' => ['main' => '14','medium' => '','small' => '','limit' => '0']		
	]
];